/*
 * Decompiled with CFR 0.152.
 */
package nl.colorize.multimedialib.scene;

import com.google.common.base.Preconditions;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import nl.colorize.multimedialib.graphics.Animation;
import nl.colorize.multimedialib.graphics.ColorRGB;
import nl.colorize.multimedialib.graphics.Image;
import nl.colorize.multimedialib.graphics.PolygonModel;
import nl.colorize.multimedialib.graphics.Sprite;
import nl.colorize.multimedialib.graphics.TTFont;
import nl.colorize.multimedialib.renderer.Audio;
import nl.colorize.multimedialib.renderer.FilePointer;
import nl.colorize.multimedialib.renderer.MediaLoader;

public class MediaManager {
    private MediaLoader mediaLoader;
    private Map<String, Object> assets;

    public MediaManager(MediaLoader mediaLoader) {
        this.mediaLoader = mediaLoader;
        this.assets = new HashMap<String, Object>();
    }

    private <T> T access(String key, Supplier<T> loader) {
        if (this.assets.containsKey(key)) {
            return (T)this.assets.get(key);
        }
        T asset = loader.get();
        this.assets.put(key, asset);
        return asset;
    }

    private <T> T access(FilePointer key, Supplier<T> loader) {
        return this.access(key.getPath(), loader);
    }

    public Image getImage(FilePointer file) {
        return this.access(file, () -> this.mediaLoader.loadImage(file));
    }

    public Audio getAudio(FilePointer file) {
        return this.access(file, () -> this.mediaLoader.loadAudio(file));
    }

    public TTFont loadFont(FilePointer file, String family, int size, ColorRGB color, boolean bold) {
        String key = file.getPath() + "@" + size + "@" + color + "@" + bold;
        return this.access(key, () -> this.mediaLoader.loadFont(file, family, size, color, bold));
    }

    public PolygonModel getModel(FilePointer file) {
        return this.access(file, () -> this.mediaLoader.loadModel(file));
    }

    public String getText(FilePointer file) {
        return this.access(file, () -> this.mediaLoader.loadText(file));
    }

    public void storeAnimation(String key, Animation anim) {
        this.assets.put(key, anim);
    }

    public Animation getAnimation(String key) {
        Preconditions.checkArgument((boolean)this.assets.containsKey(key), (Object)("No such animation: " + key));
        return (Animation)this.assets.get(key);
    }

    public void storeSprite(String key, Sprite sprite) {
        this.assets.put(key, sprite);
    }

    public Sprite getSprite(String key) {
        Preconditions.checkArgument((boolean)this.assets.containsKey(key), (Object)("No such sprite: " + key));
        return (Sprite)this.assets.get(key);
    }

    public void unload(FilePointer file) {
        this.assets.remove(file.getPath());
    }

    public void unloadAll() {
        this.assets.clear();
    }
}

