/*
 * Decompiled with CFR 0.152.
 */
package nl.colorize.multimedialib.scene;

import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.List;
import nl.colorize.multimedialib.graphics.GraphicsLayer2D;
import nl.colorize.multimedialib.math.RotatingBuffer;
import nl.colorize.multimedialib.renderer.Canvas;
import nl.colorize.multimedialib.renderer.InputDevice;
import nl.colorize.multimedialib.renderer.MediaLoader;
import nl.colorize.multimedialib.renderer.NetworkAccess;
import nl.colorize.multimedialib.renderer.teavm.TeaRenderer;
import nl.colorize.multimedialib.scene.Agent;
import nl.colorize.multimedialib.scene.MediaManager;
import nl.colorize.multimedialib.scene.Scene;
import nl.colorize.multimedialib.scene.Stage;
import nl.colorize.multimedialib.scene.Updatable;
import nl.colorize.util.Platform;
import nl.colorize.util.PlatformFamily;
import nl.colorize.util.Stopwatch;

public final class SceneContext
implements Updatable {
    private Canvas canvas;
    private Stage stage;
    private InputDevice inputDevice;
    private MediaLoader mediaLoader;
    private MediaManager media;
    private NetworkAccess network;
    private Scene activeScene;
    private Scene requestedScene;
    private List<Agent> activeAgents;
    private List<Agent> requestedAgents;
    private List<Agent> completedAgents;
    private Stopwatch fpsTimer;
    private RotatingBuffer fpsBuffer;
    private RotatingBuffer frameTimeBuffer;
    private static final int FPS_MEASUREMENT_BUFFER_SIZE = 100;

    public SceneContext(Canvas canvas, InputDevice input, MediaLoader mediaLoader, NetworkAccess network) {
        this.canvas = canvas;
        this.stage = new Stage(canvas);
        this.inputDevice = input;
        this.mediaLoader = mediaLoader;
        this.media = new MediaManager(mediaLoader);
        this.network = network;
        this.activeScene = null;
        this.requestedScene = null;
        this.activeAgents = new ArrayList<Agent>();
        this.requestedAgents = new ArrayList<Agent>();
        this.completedAgents = new ArrayList<Agent>();
        this.fpsTimer = new Stopwatch();
        this.fpsBuffer = new RotatingBuffer(100, 1000.0f);
        this.frameTimeBuffer = new RotatingBuffer(100);
    }

    @Override
    public void update(float deltaTime) {
        Preconditions.checkState((this.activeScene != null || this.requestedScene != null ? 1 : 0) != 0, (Object)"No initial scene requested");
        long fpsValue = this.fpsTimer.tick();
        this.fpsBuffer.add(fpsValue);
        Stopwatch frameTimer = new Stopwatch();
        frameTimer.tick();
        this.updateFrame(deltaTime);
        long actualFrameTime = frameTimer.tick();
        this.frameTimeBuffer.add(actualFrameTime);
    }

    private void updateFrame(float deltaTime) {
        if (this.requestedScene != null) {
            this.activateRequestedScene();
        }
        this.activeAgents.addAll(this.requestedAgents);
        this.requestedAgents.clear();
        this.activeAgents.removeAll(this.completedAgents);
        this.completedAgents.clear();
        this.updateActiveScene(deltaTime);
    }

    private void updateActiveScene(float deltaTime) {
        this.activeScene.update(this, deltaTime);
        for (Agent agent : this.activeAgents) {
            agent.update(deltaTime);
            if (!agent.isCompleted()) continue;
            this.completedAgents.add(agent);
        }
    }

    private void activateRequestedScene() {
        if (this.activeScene != null) {
            this.activeScene.end(this);
            this.activeAgents.clear();
            this.completedAgents.clear();
            this.stage.clear();
        }
        this.activeScene = this.requestedScene;
        this.requestedScene = null;
        this.activeScene.start(this);
        if (this.activeScene instanceof GraphicsLayer2D) {
            this.stage.addLayer((GraphicsLayer2D)((Object)this.activeScene));
        }
    }

    public void changeScene(Scene requestedScene) {
        Preconditions.checkState((this.requestedScene == null ? 1 : 0) != 0, (Object)("Another scene has already been requested: " + requestedScene));
        this.requestedScene = requestedScene;
    }

    public void attachAgent(Agent agent) {
        this.requestedAgents.add(agent);
        if (agent instanceof GraphicsLayer2D) {
            this.stage.addLayer((GraphicsLayer2D)((Object)agent));
        }
    }

    public void cancelAgent(Agent agent) {
        this.activeAgents.remove(agent);
        this.requestedAgents.remove(agent);
    }

    public Canvas getCanvas() {
        return this.canvas;
    }

    public Stage getStage() {
        return this.stage;
    }

    public InputDevice getInputDevice() {
        return this.inputDevice;
    }

    public MediaLoader getMediaLoader() {
        return this.mediaLoader;
    }

    public MediaManager getMedia() {
        return this.media;
    }

    public NetworkAccess getNetworkAccess() {
        return this.network;
    }

    public PlatformFamily getPlatform() {
        if (Platform.isTeaVM()) {
            return TeaRenderer.getPlatform();
        }
        return Platform.getPlatformFamily();
    }

    public String getDistributionChannel() {
        PlatformFamily platform = this.getPlatform();
        switch (platform) {
            case IOS: {
                return "App Store";
            }
            case ANDROID: {
                return "Google Play";
            }
            case MAC: {
                return "Mac App Store";
            }
            case TEAVM: {
                return "Web";
            }
        }
        return "Download";
    }

    public String getScreenSize() {
        int width = Math.round((float)this.canvas.getWidth() * this.canvas.getZoomLevel());
        int height = Math.round((float)this.canvas.getHeight() * this.canvas.getZoomLevel());
        return width + "x" + height;
    }

    public float getAverageFramerate() {
        return 1000.0f / this.fpsBuffer.getAverageValue();
    }

    public float getAverageFrameTime() {
        return this.frameTimeBuffer.getAverageValue();
    }

    public boolean canQuit() {
        return Platform.isWindows() || Platform.isMac();
    }

    public void quit() {
        if (this.canQuit()) {
            System.exit(0);
        }
    }
}

