/*
 * Decompiled with CFR 0.152.
 */
package nl.colorize.multimedialib.scene;

import nl.colorize.multimedialib.scene.State;

public class SimpleState
implements State {
    private String name;
    private float duration;
    private State next;
    private boolean interruptable;

    public SimpleState(String name, float duration, State next, boolean interruptable) {
        this.name = name;
        this.duration = duration;
        this.next = next;
        this.interruptable = interruptable;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public float getDuration() {
        return this.duration;
    }

    @Override
    public State getNext() {
        return this.next;
    }

    @Override
    public boolean isInterruptable() {
        return this.interruptable;
    }

    public boolean equals(Object o) {
        if (o instanceof SimpleState) {
            SimpleState other = (SimpleState)o;
            return this.name.equals(other.name);
        }
        return false;
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public String toString() {
        return this.name;
    }

    public static SimpleState create(String name) {
        return new SimpleState(name, 0.0f, null, true);
    }

    public static SimpleState timed(String name, float duration, State next) {
        return new SimpleState(name, duration, next, true);
    }

    public static SimpleState uninterruptable(String name, float duration, State next) {
        return new SimpleState(name, duration, next, false);
    }

    public static SimpleState permanent(String name, boolean interruptable) {
        return new SimpleState(name, 0.0f, null, interruptable);
    }

    @Deprecated
    public static SimpleState permanent(String name) {
        return SimpleState.permanent(name, false);
    }
}

