/*
 * Decompiled with CFR 0.152.
 */
package nl.colorize.multimedialib.scene;

import java.util.ArrayList;
import java.util.List;
import nl.colorize.multimedialib.graphics.ColorRGB;
import nl.colorize.multimedialib.graphics.GraphicsLayer2D;
import nl.colorize.multimedialib.graphics.PolygonModel;
import nl.colorize.multimedialib.math.Point3D;
import nl.colorize.multimedialib.renderer.Canvas;
import nl.colorize.multimedialib.renderer.GraphicsContext2D;

public final class Stage {
    private Canvas canvas;
    private List<GraphicsLayer2D> layers;
    private Point3D cameraPosition;
    private Point3D cameraTarget;
    private ColorRGB ambientLight;
    private ColorRGB lightColor;
    private Point3D lightPosition;
    private List<PolygonModel> models;

    public Stage(Canvas canvas) {
        this.canvas = canvas;
        this.layers = new ArrayList<GraphicsLayer2D>();
        this.cameraPosition = new Point3D(10.0f, 10.0f, 10.0f);
        this.cameraTarget = new Point3D(0.0f, 0.0f, 0.0f);
        this.ambientLight = new ColorRGB(100, 100, 100);
        this.lightColor = new ColorRGB(200, 200, 200);
        this.lightPosition = new Point3D(-1.0f, -0.8f, -0.2f);
        this.models = new ArrayList<PolygonModel>();
    }

    public void clear() {
        for (PolygonModel model : this.models) {
            model.detach();
        }
        this.layers.clear();
        this.models.clear();
    }

    public Canvas getCanvas() {
        return this.canvas;
    }

    public void addLayer(GraphicsLayer2D layer) {
        if (!this.layers.contains(layer)) {
            this.layers.add(layer);
        }
    }

    public void addBackgroundLayer(GraphicsLayer2D layer) {
        if (!this.layers.contains(layer)) {
            this.layers.add(0, layer);
        }
    }

    public void render2D(GraphicsContext2D graphicsContext) {
        for (GraphicsLayer2D layer : this.layers) {
            layer.render(graphicsContext);
        }
    }

    public void moveCamera(Point3D position, Point3D target) {
        this.cameraPosition = position;
        this.cameraTarget = target;
    }

    public Point3D getCameraPosition() {
        return this.cameraPosition;
    }

    public Point3D getCameraTarget() {
        return this.cameraTarget;
    }

    public void changeAmbientLight(ColorRGB color) {
        this.ambientLight = color;
    }

    public ColorRGB getAmbientLight() {
        return this.ambientLight;
    }

    public void changeLight(ColorRGB color, Point3D target) {
        this.lightColor = color;
        this.lightPosition = target;
    }

    public ColorRGB getLightColor() {
        return this.lightColor;
    }

    public Point3D getLightPosition() {
        return this.lightPosition;
    }

    public void add(PolygonModel model) {
        model.attach();
        this.models.add(model);
    }

    public void remove(PolygonModel model) {
        model.detach();
        this.models.remove(model);
    }

    public Iterable<PolygonModel> getModels() {
        return this.models;
    }
}

