/*
 * Decompiled with CFR 0.152.
 */
package nl.colorize.multimedialib.scene.effect;

import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import nl.colorize.multimedialib.graphics.Align;
import nl.colorize.multimedialib.graphics.Animation;
import nl.colorize.multimedialib.graphics.GraphicsLayer2D;
import nl.colorize.multimedialib.graphics.Image;
import nl.colorize.multimedialib.graphics.Sprite;
import nl.colorize.multimedialib.graphics.TTFont;
import nl.colorize.multimedialib.graphics.Transform;
import nl.colorize.multimedialib.math.Point2D;
import nl.colorize.multimedialib.renderer.GraphicsContext2D;
import nl.colorize.multimedialib.scene.Agent;
import nl.colorize.multimedialib.scene.Updatable;
import nl.colorize.util.animation.Interpolation;
import nl.colorize.util.animation.Timeline;

public abstract class Effect
implements Agent,
GraphicsLayer2D {
    private Timeline timeline;
    private List<Consumer<Float>> modifiers;
    private List<Updatable> frameUpdateHandlers;
    private List<Runnable> completeHandlers;
    private Point2D position;
    private Transform transform;

    protected Effect(Timeline timeline) {
        this.timeline = timeline;
        this.modifiers = new ArrayList<Consumer<Float>>();
        this.frameUpdateHandlers = new ArrayList<Updatable>();
        this.completeHandlers = new ArrayList<Runnable>();
        this.position = new Point2D(0.0f, 0.0f);
        this.transform = new Transform();
    }

    protected Effect(float duration) {
        this(new Timeline().addKeyFrame(0.0f, 0.0f).addKeyFrame(duration, 1.0f));
    }

    public Effect modify(Consumer<Float> modifier) {
        this.modifiers.add(modifier);
        return this;
    }

    public Effect modifyFrameUpdate(Updatable modifier) {
        this.frameUpdateHandlers.add(modifier);
        return this;
    }

    public Effect onComplete(Runnable observer) {
        this.completeHandlers.add(observer);
        return this;
    }

    protected Timeline getTimeline() {
        return this.timeline;
    }

    public void setPosition(Point2D position) {
        this.position = position;
    }

    public void setPosition(float x, float y) {
        this.position.set(x, y);
    }

    public Point2D getPosition() {
        return this.position;
    }

    public void setTransform(Transform transform) {
        this.transform = transform;
    }

    public Transform getTransform() {
        return this.transform;
    }

    @Override
    public void update(float deltaTime) {
        if (this.isCompleted()) {
            return;
        }
        this.timeline.onFrame(deltaTime);
        this.modifiers.forEach(modifier -> modifier.accept(Float.valueOf(this.timeline.getValue())));
        this.frameUpdateHandlers.forEach(callback -> callback.update(deltaTime));
        if (this.isCompleted()) {
            this.completeHandlers.forEach(Runnable::run);
        }
    }

    @Override
    public abstract void render(GraphicsContext2D var1);

    @Override
    public boolean isCompleted() {
        return this.timeline.isCompleted() && !this.timeline.isLoop();
    }

    public static Effect forGraphics(float duration, final GraphicsLayer2D callback) {
        return new Effect(duration){

            @Override
            public void render(GraphicsContext2D graphics) {
                callback.render(graphics);
            }
        };
    }

    public static Effect forSprite(final Sprite sprite, Timeline timeline) {
        return new Effect(timeline){

            @Override
            public void update(float deltaTime) {
                super.update(deltaTime);
                sprite.update(deltaTime);
            }

            @Override
            public void render(GraphicsContext2D graphics) {
                sprite.setPosition(this.getPosition());
                sprite.setTransform(this.getTransform());
                graphics.drawSprite(sprite);
            }
        };
    }

    public static Effect forSprite(Sprite sprite, float duration) {
        Timeline timeline = new Timeline();
        timeline.addKeyFrame(0.0f, 0.0f);
        timeline.addKeyFrame(duration, 1.0f);
        return Effect.forSprite(sprite, timeline);
    }

    public static Effect forSpriteX(Sprite sprite, Timeline timeline) {
        Effect effect = Effect.forSprite(sprite, timeline);
        effect.modify(value -> effect.getPosition().setX(value.floatValue()));
        return effect;
    }

    public static Effect forSpriteY(Sprite sprite, Timeline timeline) {
        Effect effect = Effect.forSprite(sprite, timeline);
        effect.modify(value -> effect.getPosition().setY(value.floatValue()));
        return effect;
    }

    public static Effect forSpriteRotation(Sprite sprite, float duration) {
        Preconditions.checkArgument((duration > 0.0f ? 1 : 0) != 0, (Object)("Invalid duration: " + duration));
        Timeline timeline = new Timeline(Interpolation.LINEAR, true);
        timeline.addKeyFrame(0.0f, 0.0f);
        timeline.addKeyFrame(duration, 360.0f);
        Effect effect = Effect.forSprite(sprite, timeline);
        effect.modify(value -> effect.getTransform().setRotation(Math.round(value.floatValue())));
        return effect;
    }

    public static Effect forSpriteAlpha(Sprite sprite, Timeline timeline) {
        Effect effect = Effect.forSprite(sprite, timeline);
        effect.modify(value -> effect.getTransform().setAlpha(Math.round(value.floatValue())));
        return effect;
    }

    public static Effect forAnimation(Animation anim, Timeline timeline) {
        Sprite sprite = new Sprite();
        sprite.addState("_effect", anim);
        return Effect.forSprite(sprite, timeline);
    }

    public static Effect forAnimation(Animation anim, float duration) {
        Timeline timeline = new Timeline();
        timeline.addKeyFrame(0.0f, 0.0f);
        timeline.addKeyFrame(duration, 0.0f);
        return Effect.forAnimation(anim, timeline);
    }

    public static Effect forAnimation(Animation anim) {
        return Effect.forAnimation(anim, anim.getDuration());
    }

    public static Effect forImage(Image image, Timeline timeline) {
        return Effect.forAnimation(new Animation(image), timeline);
    }

    public static Effect forImage(Image image, float duration) {
        return Effect.forAnimation(new Animation(image), duration);
    }

    public static Effect forText(final String text, final TTFont font, final Align align, Timeline timeline) {
        return new Effect(timeline){

            @Override
            public void render(GraphicsContext2D graphics) {
                graphics.drawText(text, font, this.getPosition().getX(), this.getPosition().getY(), align, this.getTransform());
            }
        };
    }

    public static Effect forText(String text, TTFont font, Align align, float duration) {
        Timeline timeline = new Timeline().addKeyFrame(0.0f, 0.0f).addKeyFrame(duration, 1.0f);
        return Effect.forText(text, font, align, timeline);
    }

    public static Effect forTextAppear(final String text, final TTFont font, final Align align, float duration) {
        Preconditions.checkArgument((text.length() > 0 ? 1 : 0) != 0, (Object)"Cannot animate empty text");
        Preconditions.checkArgument((duration > 0.0f ? 1 : 0) != 0, (Object)("Invalid duration: " + duration));
        final Timeline timeline = new Timeline();
        timeline.addKeyFrame(0.0f, 0.0f);
        timeline.addKeyFrame(duration, (float)text.length());
        return new Effect(timeline){

            @Override
            public void render(GraphicsContext2D graphics) {
                String visibleText = text.substring(0, (int)timeline.getValue());
                graphics.drawText(visibleText, font, this.getPosition().getX(), this.getPosition().getY(), align, this.getTransform());
            }
        };
    }

    public static Effect forTextAlpha(String text, TTFont font, Align align, Timeline timeline) {
        Effect effect = Effect.forText(text, font, align, timeline);
        effect.modify(value -> effect.getTransform().setAlpha(Math.round(value.floatValue())));
        return effect;
    }
}

