/*
 * Decompiled with CFR 0.152.
 */
package nl.colorize.multimedialib.scene.effect;

import java.util.ArrayList;
import java.util.List;
import nl.colorize.multimedialib.scene.Agent;
import nl.colorize.multimedialib.scene.Updatable;

public class Timer
implements Agent {
    private float position = 0.0f;
    private float duration;
    private List<Updatable> frameUpdateActions;
    private List<Runnable> completionActions;

    public Timer(float duration) {
        this.duration = duration;
        this.frameUpdateActions = new ArrayList<Updatable>();
        this.completionActions = new ArrayList<Runnable>();
        this.reset();
    }

    @Override
    public void update(float deltaTime) {
        if (this.isCompleted()) {
            return;
        }
        this.position = Math.min(this.position + deltaTime, this.duration);
        for (Updatable updatable : this.frameUpdateActions) {
            updatable.update(deltaTime);
        }
        if (this.isCompleted()) {
            for (Runnable runnable : this.completionActions) {
                runnable.run();
            }
        }
    }

    public float getTime() {
        return this.position;
    }

    public float getDuration() {
        return this.duration;
    }

    @Override
    public boolean isCompleted() {
        return this.position >= this.duration;
    }

    public float getRatio() {
        return this.position / this.duration;
    }

    public void reset() {
        this.position = 0.0f;
    }

    public void end() {
        this.position = this.duration;
    }

    public void attachFrameUpdate(Updatable action) {
        this.frameUpdateActions.add(action);
    }

    public void attachCompletion(Runnable action) {
        this.completionActions.add(action);
    }

    @Deprecated
    public void attach(Runnable action) {
        this.attachCompletion(action);
    }

    public static Timer create(float duration, Runnable completion) {
        Timer timer = new Timer(duration);
        timer.attachCompletion(completion);
        return timer;
    }

    public static Timer create(float duration, Updatable frameUpdate, Runnable completion) {
        Timer timer = new Timer(duration);
        timer.attachFrameUpdate(frameUpdate);
        timer.attachCompletion(completion);
        return timer;
    }

    public static Timer indefinite() {
        return new Timer(Float.MAX_VALUE);
    }

    public static Timer completed() {
        return new Timer(0.0f);
    }
}

