/*
 * Decompiled with CFR 0.152.
 */
package nl.colorize.multimedialib.scene.ui;

import com.google.common.base.Preconditions;
import nl.colorize.multimedialib.graphics.GraphicsLayer2D;
import nl.colorize.multimedialib.renderer.GraphicsContext2D;
import nl.colorize.multimedialib.scene.Agent;
import nl.colorize.multimedialib.scene.ui.Location;
import nl.colorize.multimedialib.scene.ui.WidgetStyle;

public abstract class Widget
implements Agent,
GraphicsLayer2D {
    private boolean visible;
    private Location location;
    private WidgetStyle style;

    public Widget(WidgetStyle style) {
        Preconditions.checkArgument((style != null ? 1 : 0) != 0, (Object)"Widget style is required");
        this.visible = true;
        this.location = Location.fixed(0.0f, 0.0f);
        this.style = style;
    }

    public void setVisible(boolean visible) {
        this.visible = visible;
    }

    public boolean isVisible() {
        return this.visible;
    }

    public void setLocation(Location location) {
        this.location = location;
    }

    public Location getLocation() {
        return this.location;
    }

    protected float getX() {
        return this.location.getX();
    }

    protected float getY() {
        return this.location.getY();
    }

    public WidgetStyle getStyle() {
        return this.style;
    }

    @Override
    public final void render(GraphicsContext2D graphics) {
        if (this.style.getBackgroundGraphics() != null) {
            this.style.getBackgroundGraphics().render(graphics);
        }
        this.render(graphics, this.style);
    }

    protected abstract void render(GraphicsContext2D var1, WidgetStyle var2);

    @Override
    public final boolean isCompleted() {
        return false;
    }
}

