/*
 * Decompiled with CFR 0.152.
 */
package nl.colorize.multimedialib.tool;

import com.google.common.base.Charsets;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.nio.charset.Charset;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import nl.colorize.multimedialib.renderer.MediaException;
import nl.colorize.multimedialib.tool.CommandLineTool;
import nl.colorize.util.FileUtils;
import nl.colorize.util.Formatting;
import nl.colorize.util.LoadUtils;
import nl.colorize.util.LogHelper;
import nl.colorize.util.ResourceFile;
import nl.colorize.util.xml.XMLHelper;
import org.jdom2.Element;
import org.kohsuke.args4j.Option;
import org.teavm.diagnostics.Problem;
import org.teavm.tooling.ConsoleTeaVMToolLog;
import org.teavm.tooling.TeaVMTargetType;
import org.teavm.tooling.TeaVMTool;
import org.teavm.tooling.TeaVMToolException;
import org.teavm.tooling.TeaVMToolLog;

public class TeaVMTranspiler
extends CommandLineTool {
    @Option(name="-project", required=true, usage="Project name for the application")
    public String projectName;
    @Option(name="-renderer", required=true, usage="One of 'canvas', 'webgl', 'three'")
    public String renderer;
    @Option(name="-resources", required=true, usage="Location of the application's resource files")
    public File resourceDir;
    @Option(name="-out", required=true, usage="Output directory for the generated filess")
    public File outputDir;
    @Option(name="-main", required=true, usage="Main class that acts as application entry point")
    public String mainClassName;
    @Option(name="-minify", usage="Minifies the generated JavaScript, off by default")
    public boolean minify = false;
    private static final List<ResourceFile> WEB_RESOURCE_FILES = ImmutableList.of((Object)new ResourceFile("browser/index.html"), (Object)new ResourceFile("browser/multimedialib.css"), (Object)new ResourceFile("browser/javascript/multimedialib.js"), (Object)new ResourceFile("browser/javascript/canvas-renderer.js"), (Object)new ResourceFile("browser/javascript/webgl2d-renderer.js"), (Object)new ResourceFile("browser/javascript/threejs-renderer.js"), (Object)new ResourceFile("browser/javascript/network.js"), (Object)new ResourceFile("browser/assets/favicon.png"), (Object)new ResourceFile("browser/assets/apple-icon.png"), (Object)new ResourceFile("browser/assets/orientation-lock.png"), (Object)new ResourceFile("browser/assets/loading.gif"), (Object)new ResourceFile("browser/assets/OpenSans-Regular.ttf"), (Object[])new ResourceFile[]{new ResourceFile("colorize-logo.png"), new ResourceFile("orientation-lock.png"), new ResourceFile("ui-widget-background.png"), new ResourceFile("transition-effect.png"), new ResourceFile("browser/lib/three/build/three.min.js"), new ResourceFile("browser/lib/three/examples/js/loaders/GLTFLoader.js"), new ResourceFile("browser/lib/peerjs/peerjs.min.js")});
    private static final List<String> TEXT_FILE_TYPES = ImmutableList.of((Object)".txt", (Object)".md", (Object)".json", (Object)".yml", (Object)".yaml", (Object)".properties", (Object)".fnt", (Object)".csv", (Object)"-manifest");
    private static final List<String> RESOURCE_FILE_TYPES = ImmutableList.of((Object)".png", (Object)".jpg", (Object)".svg", (Object)".gif", (Object)".ttf", (Object)".wav", (Object)".mp3", (Object)".ogg", (Object)".gltf");
    private static final List<String> KNOWN_MISSING_CLASSES = ImmutableList.of((Object)"[java.lang.System.exit(I)V]", (Object)"[java.lang.reflect.TypeVariable]", (Object)"[java.lang.Class.getGenericSuperclass()Ljava/lang/reflect/Type;]");
    private static final List<String> SUPPORTED_RENDERS = ImmutableList.of((Object)"canvas", (Object)"webgl", (Object)"three");
    private static final Logger LOGGER = LogHelper.getLogger(TeaVMTranspiler.class);

    public static void main(String[] args) {
        TeaVMTranspiler tool = new TeaVMTranspiler();
        tool.start(args);
    }

    @Override
    public void run() {
        Preconditions.checkArgument((boolean)this.resourceDir.exists(), (Object)("Resource directory not found: " + this.resourceDir.getAbsolutePath()));
        Preconditions.checkArgument((boolean)SUPPORTED_RENDERS.contains(this.renderer), (Object)("Invalid renderer: " + this.renderer));
        this.outputDir.mkdir();
        try {
            this.copyResources();
            this.transpile();
            this.printSummary();
        }
        catch (TeaVMToolException e) {
            LOGGER.log(Level.SEVERE, "Transpiling failed", e);
        }
    }

    private void printSummary() {
        long htmlSize = new File(this.outputDir, "index.html").length();
        long jsSize = new File(this.outputDir, "classes.js").length();
        LOGGER.info("HTML file size:          " + Formatting.memoryFormat((long)htmlSize, (int)1));
        LOGGER.info("JavaScript file size:    " + Formatting.memoryFormat((long)jsSize, (int)1));
        LOGGER.info("Results saved to " + this.outputDir.getAbsolutePath());
    }

    private void transpile() throws TeaVMToolException {
        LOGGER.info("Transpiling " + this.projectName + " to JavaScript");
        TeaVMTool transpiler = new TeaVMTool();
        transpiler.setClassLoader(this.getClass().getClassLoader());
        transpiler.setDebugInformationGenerated(true);
        transpiler.setIncremental(false);
        transpiler.setLog((TeaVMToolLog)new ConsoleTeaVMToolLog(true));
        transpiler.setMainClass(this.mainClassName);
        transpiler.setMinifying(this.minify);
        transpiler.setSourceMapsFileGenerated(!this.minify);
        transpiler.setTargetDirectory(this.outputDir);
        transpiler.setTargetType(TeaVMTargetType.JAVASCRIPT);
        transpiler.generate();
        for (Problem problem : transpiler.getProblemProvider().getProblems()) {
            if (!this.shouldReport(problem)) continue;
            LOGGER.log(Level.WARNING, "Error while transpiling: " + this.format(problem));
        }
    }

    private boolean shouldReport(Problem problem) {
        String params = Arrays.toString(problem.getParams());
        return KNOWN_MISSING_CLASSES.stream().noneMatch(entry -> params.equals(entry));
    }

    private String format(Problem problem) {
        String text = problem.getText() + " " + Arrays.toString(problem.getParams());
        if (problem.getLocation() != null) {
            text = text + " (" + problem.getLocation().getSourceLocation() + ")";
        }
        return text;
    }

    private void copyResources() {
        List<ResourceFile> resourceFiles = this.gatherResourceFiles();
        resourceFiles.add(this.generateManifest(resourceFiles));
        ArrayList<ResourceFile> textFiles = new ArrayList<ResourceFile>();
        for (ResourceFile file : resourceFiles) {
            if (this.isFileType(file, TEXT_FILE_TYPES)) {
                LOGGER.info("Using text file " + file);
                textFiles.add(file);
                continue;
            }
            LOGGER.info("Copying resource file " + file);
            this.copyBinaryResourceFile(file);
        }
        for (ResourceFile file : WEB_RESOURCE_FILES) {
            if (file.getName().endsWith(".html")) {
                LOGGER.info("Generating HTML file " + file);
                this.rewriteHTML(file, textFiles);
                continue;
            }
            LOGGER.info("Generating file " + file);
            this.copyBinaryResourceFile(file);
        }
    }

    private boolean isFileType(ResourceFile needle, List<String> haystack) {
        return haystack.stream().anyMatch(type -> needle.getName().toLowerCase().endsWith((String)type));
    }

    private void rewriteHTML(ResourceFile file, List<ResourceFile> textResources) {
        File outputFile = this.getOutputFile(file);
        try (PrintWriter writer = new PrintWriter(outputFile, Charsets.UTF_8.displayName());){
            for (String line : file.readLines(Charsets.UTF_8)) {
                line = line.replace("@@@PROJECT", this.projectName);
                if ((line = line.replace("@@@RENDERER", this.renderer)).trim().equals("@@@RESOURCES")) {
                    line = this.generateTextResourceFilesHTML(textResources);
                }
                writer.println(line);
            }
        }
        catch (IOException e) {
            throw new MediaException("Cannot write to file: " + outputFile.getAbsolutePath(), e);
        }
    }

    private String generateTextResourceFilesHTML(List<ResourceFile> files) {
        StringBuilder buffer = new StringBuilder();
        for (ResourceFile file : files) {
            Element element = new Element("div");
            element.setAttribute("id", this.normalizeFileName(file).replace(".", "_"));
            element.setText(file.read(Charsets.UTF_8));
            String xml = XMLHelper.toString((Element)element);
            buffer.append(xml);
            buffer.append("\n");
        }
        return buffer.toString();
    }

    private void copyBinaryResourceFile(ResourceFile file) {
        File outputFile = this.getOutputFile(file);
        try (InputStream stream = file.openStream();){
            byte[] contents = LoadUtils.readToByteArray((InputStream)stream);
            if (file.getPath().contains("/three/") && !this.renderer.equals("three")) {
                FileUtils.write((String)"", (Charset)Charsets.UTF_8, (File)outputFile);
            } else {
                FileUtils.write((byte[])contents, (File)outputFile);
            }
        }
        catch (IOException e) {
            LOGGER.log(Level.SEVERE, "Cannot copy file " + file, e);
        }
    }

    private List<ResourceFile> gatherResourceFiles() {
        try {
            return Files.walk(this.resourceDir.toPath(), new FileVisitOption[0]).map(path -> path.toFile()).filter(file -> !file.isDirectory() && !file.getName().startsWith(".")).filter(file -> !file.getAbsolutePath().contains("/lib/")).map(file -> new ResourceFile(file)).collect(Collectors.toList());
        }
        catch (IOException e) {
            throw new MediaException("Cannot read resource files directory: " + this.resourceDir, e);
        }
    }

    private ResourceFile generateManifest(List<ResourceFile> resourceFiles) {
        try {
            File tempDir = Files.createTempDirectory("resource-file-manifest", new FileAttribute[0]).toFile();
            File manifestFile = new File(tempDir, "resource-file-manifest");
            List entries = resourceFiles.stream().map(file -> this.normalizeFileName((ResourceFile)file)).sorted().collect(Collectors.toList());
            Files.write(manifestFile.toPath(), entries, Charsets.UTF_8, new OpenOption[0]);
            return new ResourceFile(manifestFile);
        }
        catch (IOException e) {
            throw new MediaException("Cannot generate resource file manifest", e);
        }
    }

    private File getOutputFile(ResourceFile file) {
        if (this.isFileType(file, RESOURCE_FILE_TYPES)) {
            File resourcesDir = new File(this.outputDir, "resources");
            resourcesDir.mkdir();
            return new File(resourcesDir, this.normalizeFileName(file));
        }
        return new File(this.outputDir, this.normalizeFileName(file));
    }

    private String normalizeFileName(ResourceFile file) {
        return file.getName().replace("/", "_");
    }
}

