/*
 * Decompiled with CFR 0.152.
 */
package nl.colorize.multimedialib.graphics;

import com.google.common.base.Preconditions;
import nl.colorize.multimedialib.math.Point3D;

public class Transform3D {
    private Point3D position = new Point3D(0.0f, 0.0f, 0.0f);
    private float[] rotation = new float[]{0.0f, 0.0f, 0.0f, 0.0f};
    private float[] scale = new float[]{1.0f, 1.0f, 1.0f};

    public void setPosition(Point3D p) {
        this.position.set(p);
    }

    public void setPosition(float x, float y, float z) {
        this.position.set(x, y, z);
    }

    public Point3D getPosition() {
        return this.position;
    }

    public void setRotation(float x, float y, float z, float amount) {
        this.rotation[0] = x;
        this.rotation[1] = y;
        this.rotation[2] = z;
        this.rotation[3] = amount % (amount >= 0.0f ? 360.0f : -360.0f);
    }

    public float getRotationX() {
        return this.rotation[0];
    }

    public float getRotationY() {
        return this.rotation[1];
    }

    public float getRotationZ() {
        return this.rotation[2];
    }

    public float getRotationAmount() {
        return this.rotation[3];
    }

    public void setScale(float scaleX, float scaleY, float scaleZ) {
        Preconditions.checkArgument((scaleX > 0.0f ? 1 : 0) != 0, (Object)("Invalid X scale: " + scaleX));
        Preconditions.checkArgument((scaleY > 0.0f ? 1 : 0) != 0, (Object)("Invalid Y scale: " + scaleY));
        Preconditions.checkArgument((scaleZ > 0.0f ? 1 : 0) != 0, (Object)("Invalid Z scale: " + scaleZ));
        this.scale[0] = scaleX;
        this.scale[1] = scaleY;
        this.scale[2] = scaleZ;
    }

    public void setScale(float scale) {
        this.setScale(scale, scale, scale);
    }

    public float getScaleX() {
        return this.scale[0];
    }

    public float getScaleY() {
        return this.scale[1];
    }

    public float getScaleZ() {
        return this.scale[2];
    }

    public Transform3D copy() {
        Transform3D copy = new Transform3D();
        copy.setPosition(this.position);
        copy.setRotation(this.rotation[0], this.rotation[1], this.rotation[2], this.rotation[3]);
        copy.setScale(this.scale[0], this.scale[1], this.scale[2]);
        return copy;
    }
}

