/*
 * Decompiled with CFR 0.152.
 */
package nl.colorize.multimedialib.math;

import com.google.common.base.Preconditions;
import java.util.Objects;
import nl.colorize.multimedialib.math.Vector;
import nl.colorize.util.animation.Interpolation;

public class Point2D {
    private float x;
    private float y;
    public static final float EPSILON = 0.001f;

    public Point2D(float x, float y) {
        this.x = x;
        this.y = y;
    }

    public void setX(float x) {
        this.x = x;
    }

    public float getX() {
        return this.x;
    }

    public void setY(float y) {
        this.y = y;
    }

    public float getY() {
        return this.y;
    }

    public void set(float x, float y) {
        this.x = x;
        this.y = y;
    }

    public void set(Point2D p) {
        this.set(p.getX(), p.getY());
    }

    public void move(float deltaX, float deltaY) {
        this.x += deltaX;
        this.y += deltaY;
    }

    public void add(float deltaX, float deltaY) {
        this.move(deltaX, deltaY);
    }

    public void add(Point2D p) {
        this.add(p.getX(), p.getY());
    }

    public void add(Vector vector) {
        this.add(vector.getX(), vector.getY());
    }

    public void multiply(float deltaX, float deltaY) {
        this.x *= deltaX;
        this.y *= deltaY;
    }

    public float calculateDistance(Point2D other) {
        if (this.equals(other)) {
            return 0.0f;
        }
        float deltaX = Math.abs(other.x - this.x);
        float deltaY = Math.abs(other.y - this.y);
        return (float)Math.sqrt(deltaX * deltaX + deltaY * deltaY);
    }

    public float calculateAngle(Point2D other) {
        if (this.equals(other)) {
            return 0.0f;
        }
        double radians = Math.atan2(other.y - this.y, other.x - this.x);
        float angle = (float)Math.toDegrees(radians);
        if (angle < 0.0f) {
            angle += 360.0f;
        }
        return angle;
    }

    public Point2D calculateCenter(Point2D other) {
        float averageX = (this.x + other.x) / 2.0f;
        float averageY = (this.y + other.y) / 2.0f;
        return new Point2D(averageX, averageY);
    }

    public Point2D interpolate(Point2D other, float delta, Interpolation method) {
        Preconditions.checkArgument((delta >= 0.0f && delta <= 1.0f ? 1 : 0) != 0, (Object)("Delta value out of range: " + delta));
        return new Point2D(method.interpolate(this.x, other.x, delta), method.interpolate(this.y, other.y, delta));
    }

    public Point2D interpolate(Point2D other, float delta) {
        return this.interpolate(other, delta, Interpolation.LINEAR);
    }

    public boolean isOrigin() {
        return Math.abs(this.x) < 0.001f && Math.abs(this.y) < 0.001f;
    }

    public Point2D copy() {
        return new Point2D(this.x, this.y);
    }

    public boolean equals(Object o) {
        if (o instanceof Point2D) {
            Point2D other = (Point2D)o;
            return Math.abs(this.x - other.x) < 0.001f && Math.abs(this.y - other.y) < 0.001f;
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(Float.valueOf(this.x), Float.valueOf(this.y));
    }

    public String toString() {
        return "(" + Math.round(this.x) + ", " + Math.round(this.y) + ")";
    }
}

