/*
 * Decompiled with CFR 0.152.
 */
package nl.colorize.multimedialib.math;

import java.util.Objects;
import nl.colorize.multimedialib.math.Point2D;

public class Vector {
    private float direction;
    private float magnitude;
    public static final float EPSILON = 0.001f;

    public Vector(float direction, float magnitude) {
        this.set(direction, magnitude);
    }

    public void set(float direction, float magnitude) {
        this.setDirection(direction);
        this.setMagnitude(magnitude);
    }

    public void setDirection(float direction) {
        this.direction = direction;
    }

    public void addDirection(float delta) {
        this.setDirection(this.direction + delta);
    }

    public float getDirection() {
        return this.direction;
    }

    public void setMagnitude(float magnitude) {
        this.magnitude = Math.max(magnitude, 0.0f);
    }

    public void addMagnitude(float delta) {
        this.setMagnitude(this.magnitude + delta);
    }

    public float getMagnitude() {
        return this.magnitude;
    }

    public float getX() {
        return this.magnitude * (float)Math.cos(Math.toRadians(this.direction));
    }

    public float getY() {
        return this.magnitude * (float)Math.sin(Math.toRadians(this.direction));
    }

    public Point2D toPoint() {
        return new Point2D(this.getX(), this.getY());
    }

    public void setToPoint(Point2D p) {
        if (p.isOrigin()) {
            this.magnitude = 0.0f;
        } else {
            this.direction = (float)Math.toDegrees(Math.atan2(p.getY(), p.getX()));
            this.magnitude = new Point2D(0.0f, 0.0f).calculateDistance(p);
        }
    }

    public boolean isOrigin() {
        return this.magnitude < 0.001f;
    }

    public Vector copy() {
        return new Vector(this.direction, this.magnitude);
    }

    public boolean equals(Object o) {
        if (o instanceof Vector) {
            Vector other = (Vector)o;
            return Math.abs(this.direction - other.direction) < 0.001f && Math.abs(this.magnitude - other.magnitude) < 0.001f;
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(Float.valueOf(this.direction), Float.valueOf(this.magnitude));
    }

    public String toString() {
        return "[ " + Math.round(this.direction) + " " + Math.round(this.magnitude) + " ]";
    }
}

