/*
 * Decompiled with CFR 0.152.
 */
package nl.colorize.multimedialib.renderer;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Consumer;

public final class NetworkConnection {
    private AtomicBoolean connected = new AtomicBoolean(false);
    private String id = null;
    private MessageBuffer sendBuffer = new MessageBuffer();
    private MessageBuffer receiveBuffer = new MessageBuffer();
    private Consumer<String> sender;

    public NetworkConnection(Consumer<String> sender) {
        this.sender = sender;
    }

    public void connect() {
        this.connected.set(true);
        for (String message : this.sendBuffer.flush()) {
            this.sender.accept(message);
        }
    }

    public void disconnect() {
        this.connected.set(false);
    }

    public boolean isConnected() {
        return this.connected.get();
    }

    public synchronized void receiveID(String id) {
        this.id = id;
    }

    public synchronized String getID() {
        return this.id;
    }

    public void send(String message) {
        if (this.isConnected()) {
            this.sender.accept(message);
        } else {
            this.sendBuffer.add(message);
        }
    }

    public void queueReceivedMessage(String message) {
        this.receiveBuffer.add(message);
    }

    public List<String> receive() {
        return this.receiveBuffer.flush();
    }

    private static class MessageBuffer {
        private List<String> messages = new ArrayList<String>();

        public synchronized void add(String message) {
            this.messages.add(message);
        }

        public synchronized List<String> flush() {
            if (this.messages.isEmpty()) {
                return Collections.emptyList();
            }
            ImmutableList contents = ImmutableList.copyOf(this.messages);
            this.messages.clear();
            return contents;
        }

        public void flush(Consumer<String> callback) {
            this.flush().forEach(callback);
        }

        public synchronized void reset() {
            this.messages.clear();
        }
    }
}

