/*
 * Decompiled with CFR 0.152.
 */
package nl.colorize.multimedialib.renderer.java2d;

import com.google.common.base.Preconditions;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import nl.colorize.multimedialib.graphics.ColorRGB;
import nl.colorize.multimedialib.graphics.Image;
import nl.colorize.multimedialib.math.Rect;
import nl.colorize.multimedialib.renderer.FilePointer;
import nl.colorize.util.swing.Utils2D;

public class AWTImage
implements Image {
    private BufferedImage image;
    private FilePointer origin;

    public AWTImage(BufferedImage image, FilePointer origin) {
        Preconditions.checkArgument((image != null ? 1 : 0) != 0, (Object)("Null image originating from " + origin));
        this.image = image;
        this.origin = origin;
    }

    public AWTImage(BufferedImage image) {
        this(image, null);
    }

    public BufferedImage getImage() {
        return this.image;
    }

    @Override
    public Rect getRegion() {
        return new Rect(0.0f, 0.0f, this.image.getWidth(), this.image.getHeight());
    }

    @Override
    public int getWidth() {
        return this.image.getWidth();
    }

    @Override
    public int getHeight() {
        return this.image.getHeight();
    }

    @Override
    public Image extractRegion(Rect region) {
        BufferedImage subImage = this.image.getSubimage(Math.round(region.getX()), Math.round(region.getY()), Math.round(region.getWidth()), Math.round(region.getHeight()));
        return new AWTImage(subImage, this.origin);
    }

    @Override
    public ColorRGB getColor(int x, int y) {
        Preconditions.checkArgument((x >= 0 && x < this.getWidth() && y >= 0 && y < this.getHeight() ? 1 : 0) != 0, (Object)("Invalid coordinate: " + x + ", " + y));
        int rgba = this.image.getRGB(x, y);
        return new ColorRGB(rgba);
    }

    @Override
    public int getAlpha(int x, int y) {
        Preconditions.checkArgument((x >= 0 && x < this.getWidth() && y >= 0 && y < this.getHeight() ? 1 : 0) != 0, (Object)("Invalid coordinate: " + x + ", " + y));
        int rgba = this.image.getRGB(x, y);
        int alpha = rgba >> 24 & 0xFF;
        return Math.round((float)alpha / 2.55f);
    }

    @Override
    public Image tint(ColorRGB color) {
        BufferedImage tinted = new BufferedImage(this.getWidth(), this.getHeight(), 2);
        Graphics2D g2 = Utils2D.createGraphics((BufferedImage)tinted, (boolean)true, (boolean)false);
        g2.drawImage(this.image, 0, 0, this.getWidth(), this.getHeight(), null);
        g2.setComposite(AlphaComposite.SrcAtop);
        g2.setColor(new Color(color.getR(), color.getG(), color.getB()));
        g2.fillRect(0, 0, tinted.getWidth(), tinted.getHeight());
        g2.dispose();
        return new AWTImage(tinted, this.origin);
    }

    public String toString() {
        if (this.origin != null) {
            return this.origin.getPath();
        }
        return "<generated image>";
    }
}

