/*
 * Decompiled with CFR 0.152.
 */
package nl.colorize.multimedialib.renderer.libgdx;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.Preferences;
import com.badlogic.gdx.assets.loaders.FileHandleResolver;
import com.badlogic.gdx.assets.loaders.resolvers.InternalFileHandleResolver;
import com.badlogic.gdx.files.FileHandle;
import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.Pixmap;
import com.badlogic.gdx.graphics.Texture;
import com.badlogic.gdx.graphics.g2d.BitmapFont;
import com.badlogic.gdx.graphics.g2d.TextureRegion;
import com.badlogic.gdx.graphics.g2d.freetype.FreeTypeFontGenerator;
import com.badlogic.gdx.graphics.g3d.Attribute;
import com.badlogic.gdx.graphics.g3d.Material;
import com.badlogic.gdx.graphics.g3d.Model;
import com.badlogic.gdx.graphics.g3d.ModelInstance;
import com.badlogic.gdx.graphics.g3d.attributes.ColorAttribute;
import com.badlogic.gdx.graphics.g3d.attributes.TextureAttribute;
import com.badlogic.gdx.graphics.g3d.loader.G3dModelLoader;
import com.badlogic.gdx.graphics.g3d.utils.ModelBuilder;
import com.badlogic.gdx.utils.BaseJsonReader;
import com.badlogic.gdx.utils.Disposable;
import com.badlogic.gdx.utils.UBJsonReader;
import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import net.mgsx.gltf.loaders.gltf.GLTFLoader;
import net.mgsx.gltf.scene3d.scene.SceneAsset;
import nl.colorize.multimedialib.graphics.ColorRGB;
import nl.colorize.multimedialib.graphics.Image;
import nl.colorize.multimedialib.graphics.PolygonModel;
import nl.colorize.multimedialib.graphics.TTFont;
import nl.colorize.multimedialib.math.Point2D;
import nl.colorize.multimedialib.math.Point3D;
import nl.colorize.multimedialib.renderer.Audio;
import nl.colorize.multimedialib.renderer.FilePointer;
import nl.colorize.multimedialib.renderer.GeometryBuilder;
import nl.colorize.multimedialib.renderer.MediaException;
import nl.colorize.multimedialib.renderer.MediaLoader;
import nl.colorize.multimedialib.renderer.java2d.MP3;
import nl.colorize.multimedialib.renderer.java2d.StandardMediaLoader;
import nl.colorize.multimedialib.renderer.libgdx.GDXImage;
import nl.colorize.multimedialib.renderer.libgdx.GDXModel;
import nl.colorize.util.ApplicationData;
import nl.colorize.util.LogHelper;
import nl.colorize.util.Platform;
import nl.colorize.util.ResourceFile;
import org.teavm.apachecommons.io.Charsets;

public class GDXMediaLoader
implements MediaLoader,
GeometryBuilder,
Disposable {
    private List<Disposable> loaded = new ArrayList<Disposable>();
    private Map<TTFont, BitmapFont> fonts = new HashMap<TTFont, BitmapFont>();
    private Map<String, FileHandle> fontLocations = new HashMap<String, FileHandle>();
    private Map<ColorRGB, Texture> colorTextureCache = new HashMap<ColorRGB, Texture>();
    private static final int COLOR_TEXTURE_SIZE = 8;
    private static final Logger LOGGER = LogHelper.getLogger(GDXMediaLoader.class);

    @Override
    public Image loadImage(FilePointer file) {
        Texture texture = new Texture(this.getFileHandle(file));
        this.loaded.add((Disposable)texture);
        return new GDXImage(file, texture);
    }

    @Override
    public Audio loadAudio(FilePointer file) {
        return new MP3(new ResourceFile(file.getPath()));
    }

    public Texture getColorTexture(ColorRGB color) {
        Texture colorTexture = this.colorTextureCache.get(color);
        if (colorTexture == null) {
            colorTexture = this.generateColorTexture(color);
            this.colorTextureCache.put(color, colorTexture);
            this.loaded.add((Disposable)colorTexture);
        }
        return colorTexture;
    }

    private Texture generateColorTexture(ColorRGB color) {
        Pixmap pixelData = new Pixmap(8, 8, Pixmap.Format.RGBA8888);
        pixelData.setColor(this.toColor(color));
        pixelData.fillRectangle(0, 0, 8, 8);
        return new Texture(pixelData);
    }

    @Override
    public TTFont loadFont(FilePointer file, String family, int size, ColorRGB color, boolean bold) {
        this.fontLocations.put(family, this.getFileHandle(file));
        return new TTFont(family, size, color, bold);
    }

    protected BitmapFont getBitmapFont(TTFont font, int actualSize) {
        TTFont cacheKey = new TTFont(font.getFamily(), actualSize, font.getColor(), font.isBold());
        BitmapFont bitmapFont = this.fonts.get(cacheKey);
        if (bitmapFont == null) {
            bitmapFont = this.loadBitmapFont(font, actualSize);
            this.fonts.put(cacheKey, bitmapFont);
            this.loaded.add((Disposable)bitmapFont);
        }
        return bitmapFont;
    }

    private BitmapFont loadBitmapFont(TTFont font, int actualSize) {
        FileHandle fontLocation = this.fontLocations.get(font.getFamily());
        Preconditions.checkArgument((fontLocation != null ? 1 : 0) != 0, (Object)("Unknown font location: " + font));
        FreeTypeFontGenerator.FreeTypeFontParameter config = new FreeTypeFontGenerator.FreeTypeFontParameter();
        config.size = actualSize;
        config.color = this.toColor(font.getColor());
        FreeTypeFontGenerator fontGenerator = new FreeTypeFontGenerator(fontLocation);
        BitmapFont bitmapFont = fontGenerator.generateFont(config);
        fontGenerator.dispose();
        return bitmapFont;
    }

    @Override
    public String loadText(FilePointer file) {
        ResourceFile resourceFile = new ResourceFile(file.getPath());
        return resourceFile.read(Charsets.UTF_8);
    }

    @Override
    public PolygonModel loadModel(FilePointer file) {
        Model model = this.loadModel(this.getFileHandle(file));
        return this.createInstance(model);
    }

    private Model loadModel(FileHandle file) {
        if (file.toString().endsWith(".g3db")) {
            G3dModelLoader g3dLoader = new G3dModelLoader((BaseJsonReader)new UBJsonReader(), (FileHandleResolver)new InternalFileHandleResolver());
            return g3dLoader.loadModel(file);
        }
        if (file.toString().endsWith(".gltf")) {
            GLTFLoader gltfLoader = new GLTFLoader();
            SceneAsset sceneAsset = gltfLoader.load(file, true);
            return sceneAsset.scene.model;
        }
        throw new MediaException("Unsupported model file format: " + file);
    }

    private PolygonModel createInstance(Model model) {
        ModelInstance instance = new ModelInstance(model);
        this.loaded.add((Disposable)model);
        return new GDXModel(instance);
    }

    @Override
    public boolean containsResourceFile(FilePointer file) {
        return this.getFileHandle(file).exists();
    }

    @Override
    public ApplicationData loadApplicationData(String appName, String fileName) {
        if (Platform.isWindows() || Platform.isMac()) {
            StandardMediaLoader delegate = new StandardMediaLoader();
            return delegate.loadApplicationData(appName, fileName);
        }
        Preferences preferences = Gdx.app.getPreferences(appName);
        String data = preferences.getString("data", "");
        return new ApplicationData(data);
    }

    @Override
    public void saveApplicationData(ApplicationData data, String appName, String fileName) {
        if (Platform.isWindows() || Platform.isMac()) {
            StandardMediaLoader delegate = new StandardMediaLoader();
            delegate.saveApplicationData(data, appName, fileName);
        } else {
            Preferences preferences = Gdx.app.getPreferences(appName);
            preferences.putString("data", data.serialize());
            preferences.flush();
        }
    }

    private FileHandle getFileHandle(FilePointer file) {
        return this.getFileHandle(file.getPath());
    }

    private FileHandle getFileHandle(String path) {
        return Gdx.files.internal(path);
    }

    public Color toColor(ColorRGB color) {
        return new Color((float)color.getR() / 255.0f, (float)color.getG() / 255.0f, (float)color.getB() / 255.0f, 1.0f);
    }

    @Override
    public GeometryBuilder getGeometryBuilder() {
        return this;
    }

    @Override
    public PolygonModel createQuad(Point2D size, ColorRGB color) {
        return this.createBox(new Point3D(size.getX(), 0.001f, size.getY()), color);
    }

    @Override
    public PolygonModel createQuad(Point2D size, Image texture) {
        return this.createBox(new Point3D(size.getX(), 0.001f, size.getY()), texture);
    }

    @Override
    public PolygonModel createBox(Point3D size, ColorRGB color) {
        ModelBuilder modelBuilder = new ModelBuilder();
        Model model = modelBuilder.createBox(size.getX(), size.getY(), size.getZ(), this.createMaterial(color), 9L);
        return this.createInstance(model);
    }

    @Override
    public PolygonModel createBox(Point3D size, Image texture) {
        ModelBuilder modelBuilder = new ModelBuilder();
        Model model = modelBuilder.createBox(size.getX(), size.getY(), size.getZ(), this.createMaterial((GDXImage)texture), 25L);
        return this.createInstance(model);
    }

    @Override
    public PolygonModel createSphere(float diameter, ColorRGB color) {
        ModelBuilder modelBuilder = new ModelBuilder();
        Model model = modelBuilder.createSphere(diameter, diameter, diameter, 32, 32, this.createMaterial(color), 9L);
        return this.createInstance(model);
    }

    @Override
    public PolygonModel createSphere(float diameter, Image texture) {
        ModelBuilder modelBuilder = new ModelBuilder();
        Model model = modelBuilder.createSphere(diameter, diameter, diameter, 32, 32, this.createMaterial((GDXImage)texture), 25L);
        return this.createInstance(model);
    }

    private Material createMaterial(ColorRGB color) {
        ColorAttribute colorAttr = ColorAttribute.createDiffuse((Color)this.toColor(color));
        return new Material(new Attribute[]{colorAttr});
    }

    private Material createMaterial(GDXImage texture) {
        TextureAttribute colorAttr = TextureAttribute.createDiffuse((TextureRegion)texture.getTextureRegion());
        return new Material(new Attribute[]{colorAttr});
    }

    public void dispose() {
        this.loaded.forEach(Disposable::dispose);
        this.loaded.clear();
        this.fonts.clear();
        this.colorTextureCache.clear();
    }
}

