/*
 * Decompiled with CFR 0.152.
 */
package nl.colorize.multimedialib.renderer.teavm;

import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import nl.colorize.multimedialib.renderer.NetworkAccess;
import nl.colorize.multimedialib.renderer.NetworkConnection;
import nl.colorize.multimedialib.renderer.teavm.Browser;
import nl.colorize.util.Task;
import nl.colorize.util.http.Headers;
import nl.colorize.util.http.PostData;

public class TeaNetworkAccess
implements NetworkAccess {
    @Override
    public Task<String> get(String url, Headers headers) {
        String[] headersArray = this.serializeHeaders(headers);
        Task promise = new Task();
        Browser.sendGetRequest(url, headersArray, arg_0 -> ((Task)promise).complete(arg_0));
        return promise;
    }

    @Override
    public Task<String> post(String url, Headers headers, PostData data) {
        String[] headersArray = this.serializeHeaders(headers);
        String body = data.encode(StandardCharsets.UTF_8);
        Task promise = new Task();
        Browser.sendPostRequest(url, headersArray, body, arg_0 -> ((Task)promise).complete(arg_0));
        return promise;
    }

    private String[] serializeHeaders(Headers headers) {
        ArrayList<String> entries = new ArrayList<String>();
        if (headers != null) {
            for (String name : headers.getNames()) {
                for (String value : headers.getValues(name)) {
                    entries.add(name);
                    entries.add(value);
                }
            }
        }
        return entries.toArray(new String[0]);
    }

    @Override
    public boolean isWebSocketSupported() {
        return Browser.isWebSocketSupported();
    }

    @Override
    public NetworkConnection connectWebSocket(String uri) {
        NetworkConnection connection = new NetworkConnection(Browser::sendWebSocket);
        Browser.connectWebSocket(uri, message -> {
            if (message.equals("__open")) {
                connection.receiveID(uri);
                connection.connect();
            } else {
                connection.queueReceivedMessage(message);
            }
        });
        return connection;
    }

    @Override
    public boolean isWebRtcSupported() {
        return false;
    }

    @Override
    public NetworkConnection connectWebRTC(String id) {
        NetworkConnection connection = new NetworkConnection(Browser::sendPeerMessage);
        Browser.openPeerConnection(id, message -> {
            if (message.startsWith("__peer:")) {
                connection.receiveID(message.substring(7));
            } else if (message.equals("__open")) {
                connection.connect();
            } else {
                connection.queueReceivedMessage(message);
            }
        });
        return connection;
    }
}

