/*
 * Decompiled with CFR 0.152.
 */
package nl.colorize.multimedialib.renderer.teavm;

import nl.colorize.multimedialib.graphics.PolygonModel;
import nl.colorize.multimedialib.math.Point3D;
import nl.colorize.multimedialib.renderer.Canvas;
import nl.colorize.multimedialib.renderer.GraphicsMode;
import nl.colorize.multimedialib.renderer.Renderer;
import nl.colorize.multimedialib.renderer.teavm.Browser;
import nl.colorize.multimedialib.renderer.teavm.TeaGraphicsContext2D;
import nl.colorize.multimedialib.renderer.teavm.TeaInputDevice;
import nl.colorize.multimedialib.renderer.teavm.TeaMediaLoader;
import nl.colorize.multimedialib.renderer.teavm.TeaNetworkAccess;
import nl.colorize.multimedialib.scene.Scene;
import nl.colorize.multimedialib.scene.SceneContext;
import nl.colorize.multimedialib.scene.Stage;
import nl.colorize.util.PlatformFamily;

public class TeaRenderer
implements Renderer {
    private Canvas canvas;
    private TeaGraphicsContext2D graphics;
    private TeaInputDevice inputDevice;
    private TeaMediaLoader mediaLoader;
    private SceneContext context;

    public TeaRenderer(Canvas canvas) {
        this.canvas = canvas;
        this.graphics = new TeaGraphicsContext2D(canvas);
        this.inputDevice = new TeaInputDevice(canvas, TeaRenderer.getPlatform());
        this.mediaLoader = new TeaMediaLoader();
        TeaNetworkAccess network = new TeaNetworkAccess();
        this.context = new SceneContext(canvas, this.inputDevice, this.mediaLoader, network);
    }

    @Override
    public void start(Scene initialScene) {
        this.context.changeScene(initialScene);
        Browser.startAnimationLoop(this::onFrame);
    }

    @Override
    public GraphicsMode getGraphicsMode() {
        if (Browser.getRendererType().equals("three")) {
            return GraphicsMode.MODE_3D;
        }
        return GraphicsMode.MODE_2D;
    }

    private void onFrame(float deltaTime, boolean render) {
        this.updateCanvas();
        this.inputDevice.update(deltaTime);
        if (this.isReady()) {
            this.context.update(deltaTime);
            if (render) {
                this.renderStage(this.context.getStage(), deltaTime);
            }
        }
    }

    private void renderStage(Stage stage, float deltaTime) {
        if (this.getGraphicsMode() == GraphicsMode.MODE_3D) {
            Point3D camera = stage.getCameraPosition();
            Point3D cameraDirection = stage.getCameraTarget();
            Browser.moveCamera(camera.getX(), camera.getY(), camera.getZ(), cameraDirection.getX(), cameraDirection.getY(), cameraDirection.getZ());
            Browser.changeAmbientLight(stage.getAmbientLight().toHex());
            Browser.changeLight(stage.getAmbientLight().toHex());
            for (PolygonModel model : stage.getModels()) {
                model.update(deltaTime);
            }
        }
        stage.render2D(this.graphics);
    }

    private boolean isReady() {
        int canvasWidth = Math.round(Browser.getCanvasWidth());
        int canvasHeight = Math.round(Browser.getCanvasHeight());
        return canvasWidth > 0 && canvasHeight > 0 && this.mediaLoader.checkLoadingProgress();
    }

    private void updateCanvas() {
        int canvasWidth = Math.round(Browser.getCanvasWidth());
        int canvasHeight = Math.round(Browser.getCanvasHeight());
        if (canvasWidth > 0 && canvasHeight > 0) {
            this.canvas.resizeScreen(canvasWidth, canvasHeight);
        }
    }

    @Override
    public String takeScreenshot() {
        return Browser.takeScreenshot();
    }

    public static PlatformFamily getPlatform() {
        String userAgent = Browser.getUserAgent().toLowerCase();
        if (userAgent.contains("iphone") || userAgent.contains("ipad")) {
            return PlatformFamily.IOS;
        }
        if (userAgent.contains("android")) {
            return PlatformFamily.ANDROID;
        }
        if (userAgent.contains("mac")) {
            return PlatformFamily.MAC;
        }
        return PlatformFamily.WINDOWS;
    }
}

