/*
 * Decompiled with CFR 0.152.
 */
package nl.colorize.multimedialib.scene;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import nl.colorize.multimedialib.renderer.Canvas;
import nl.colorize.multimedialib.renderer.FilePointer;
import nl.colorize.multimedialib.renderer.Renderer;
import nl.colorize.multimedialib.renderer.WindowOptions;
import nl.colorize.multimedialib.renderer.headless.HeadlessRenderer;
import nl.colorize.multimedialib.renderer.java2d.Java2DRenderer;
import nl.colorize.multimedialib.renderer.libgdx.GDXRenderer;
import nl.colorize.multimedialib.renderer.teavm.TeaRenderer;
import nl.colorize.multimedialib.scene.Scene;
import nl.colorize.util.Platform;
import nl.colorize.util.swing.ApplicationMenuListener;

public final class MultimediaAppLauncher {
    private Canvas canvas;
    private int framerate;
    private WindowOptions windowOptions;
    private static final String DEFAULT_WINDOW_TITLE = "MultimediaLib";
    private static final FilePointer DEFAULT_ICON = new FilePointer("colorize-icon-32.png");

    private MultimediaAppLauncher(Canvas canvas) {
        this.canvas = canvas;
        this.framerate = 60;
        this.windowOptions = new WindowOptions(DEFAULT_WINDOW_TITLE, DEFAULT_ICON);
    }

    public MultimediaAppLauncher withFramerate(int framerate) {
        Preconditions.checkArgument((boolean)ImmutableList.of((Object)20, (Object)25, (Object)30, (Object)60, (Object)120).contains((Object)framerate), (Object)("Framerate not supported: " + framerate));
        this.framerate = framerate;
        return this;
    }

    public MultimediaAppLauncher withWindowTitle(String title) {
        this.windowOptions.setTitle(title);
        return this;
    }

    public MultimediaAppLauncher withWindowIcon(FilePointer iconFile) {
        this.windowOptions.setIconFile(iconFile);
        return this;
    }

    public MultimediaAppLauncher withFullscreen(boolean fullscreen) {
        this.windowOptions.setFullscreen(fullscreen);
        return this;
    }

    public MultimediaAppLauncher withFullscreen() {
        return this.withFullscreen(true);
    }

    public MultimediaAppLauncher withMacApplicationMenu(ApplicationMenuListener listener) {
        this.windowOptions.setAppMenuListener(listener);
        return this;
    }

    public MultimediaAppLauncher withWindowOptions(WindowOptions windowOptions) {
        this.windowOptions = windowOptions;
        return this;
    }

    public Renderer startJava2D(Scene initialScene) {
        Java2DRenderer renderer = new Java2DRenderer(this.canvas, this.framerate, this.windowOptions);
        renderer.start(initialScene);
        return renderer;
    }

    public Renderer startGDX(Scene initialScene) {
        GDXRenderer renderer = new GDXRenderer(this.canvas, this.framerate, this.windowOptions);
        renderer.start(initialScene);
        return renderer;
    }

    public Renderer startTea(Scene initialScene) {
        Platform.enableTeaVM();
        TeaRenderer renderer = new TeaRenderer(this.canvas);
        renderer.start(initialScene);
        return renderer;
    }

    @VisibleForTesting
    public void startHeadless(Scene initialScene) {
        HeadlessRenderer renderer = new HeadlessRenderer();
        renderer.start(initialScene);
    }

    public static MultimediaAppLauncher create(Canvas canvas) {
        return new MultimediaAppLauncher(canvas);
    }
}

