/*
 * Decompiled with CFR 0.152.
 */
package nl.colorize.multimedialib.scene;

import com.google.common.base.Preconditions;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ListMultimap;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import nl.colorize.multimedialib.scene.Updatable;

public class Recorder
implements Updatable {
    private float interval;
    private int capacity;
    private Map<String, Supplier<Float>> objects;
    private ListMultimap<String, Float> data;
    private float time;

    public Recorder(float interval, int capacity) {
        Preconditions.checkArgument((interval > 0.0f ? 1 : 0) != 0, (Object)("Invalid interval: " + interval));
        Preconditions.checkArgument((capacity > 0 ? 1 : 0) != 0, (Object)("Invalid capacity: " + capacity));
        this.interval = interval;
        this.capacity = capacity;
        this.objects = new HashMap<String, Supplier<Float>>();
        this.data = ArrayListMultimap.create();
        this.time = 0.0f;
    }

    public void record(String objectId, Supplier<Float> object) {
        Preconditions.checkArgument((!this.objects.containsKey(objectId) ? 1 : 0) != 0, (Object)("Object ID is already in use: " + objectId));
        this.objects.put(objectId, object);
    }

    @Override
    public void update(float deltaTime) {
        this.time += deltaTime;
        while (this.time >= this.interval) {
            this.time = Math.max(this.time - this.interval, 0.0f);
            for (String objectId : this.objects.keySet()) {
                Float value = this.objects.get(objectId).get();
                this.data.put((Object)objectId, (Object)value);
            }
        }
        this.trimCapacity();
    }

    private void trimCapacity() {
        List trim = this.data.keySet().stream().filter(objectId -> this.data.get(objectId).size() > this.capacity).collect(Collectors.toList());
        for (String objectId2 : trim) {
            List values = this.data.get((Object)objectId2);
            if (values.size() <= this.capacity) continue;
            values = ImmutableList.copyOf(values.subList(values.size() - this.capacity, values.size()));
            this.data.replaceValues((Object)objectId2, (Iterable)values);
        }
    }

    public Set<String> getRecordedObjects() {
        return this.data.keySet();
    }

    public List<Float> getRecordedValues(String objectId) {
        Preconditions.checkArgument((boolean)this.objects.containsKey(objectId), (Object)("Object has not been recorded: " + objectId));
        return this.data.get((Object)objectId);
    }

    public float getInterval() {
        return this.interval;
    }

    public int getCapacity() {
        return this.capacity;
    }
}

