/*
 * Decompiled with CFR 0.152.
 */
package nl.colorize.multimedialib.scene.effect;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import nl.colorize.multimedialib.graphics.ColorRGB;
import nl.colorize.multimedialib.math.MathUtils;
import nl.colorize.multimedialib.math.RandomGenerator;
import nl.colorize.multimedialib.math.Rect;
import nl.colorize.multimedialib.renderer.GraphicsContext2D;
import nl.colorize.multimedialib.scene.effect.Effect;

public class FireEffect
extends Effect {
    private Rect area;
    private int pixelSize;
    private List<ColorRGB> palette;
    private float duration;
    private int[] firePixels;
    private float timer;
    private float totalTime;
    private static final List<String> DEFAULT_PALETTE = ImmutableList.of((Object)"#070707", (Object)"#1F0707", (Object)"#2F0F07", (Object)"#470F07", (Object)"#571707", (Object)"#671F07", (Object)"#771F07", (Object)"#8F2707", (Object)"#9F2F07", (Object)"#AF3F07", (Object)"#BF4707", (Object)"#C74707", (Object[])new String[]{"#DF4F07", "#DF5707", "#DF5707", "#D75F07", "#D7670F", "#CF6F0F", "#CF770F", "#CF7F0F", "#CF8717", "#C78717", "#C78F17", "#C7971F", "#BF9F1F", "#BF9F1F", "#BFA727", "#BFA727", "#BFAF2F", "#B7AF2F", "#B7B72F", "#B7B737", "#CFCF6F", "#DFDF9F", "#EFEFC7", "#FFFFFF"});
    private static final float FRAME_TIME = 0.033333335f;

    public FireEffect(float duration, Rect area, int pixelSize, List<ColorRGB> palette) {
        super(duration);
        Preconditions.checkArgument((area.getWidth() > 0.0f && area.getHeight() > 0.0f ? 1 : 0) != 0, (Object)"Invalid area");
        Preconditions.checkArgument((pixelSize >= 1 ? 1 : 0) != 0, (Object)"Invalid pixel size");
        Preconditions.checkArgument((palette.size() >= 10 ? 1 : 0) != 0, (Object)"Palette too small");
        Preconditions.checkArgument((duration >= 1.0f ? 1 : 0) != 0, (Object)"Duration too short");
        this.area = area.copy();
        this.pixelSize = pixelSize;
        this.palette = palette;
        this.duration = duration;
        this.setup();
        this.modifyFrameUpdate(this::updateFire);
    }

    public FireEffect(float duration, int pixelSize, Rect area) {
        this(duration, area, pixelSize, DEFAULT_PALETTE.stream().map(ColorRGB::parseHex).collect(Collectors.toList()));
    }

    private void setup() {
        this.firePixels = new int[this.getWidth() * this.getHeight()];
        Arrays.fill(this.firePixels, 0);
        for (int x = 0; x < this.getWidth(); ++x) {
            this.setFirePixel(x, this.getHeight() - 1, this.palette.size() - 1);
        }
        this.timer = 0.0f;
        this.totalTime = 0.0f;
    }

    private void updateFire(float deltaTime) {
        this.timer += deltaTime;
        this.totalTime += deltaTime;
        if (this.timer >= 0.033333335f) {
            this.spreadFire();
            if (this.totalTime >= 0.7f * this.duration) {
                this.fadeFire();
            }
            this.timer = 0.0f;
        }
    }

    private void spreadFire() {
        for (int x = 0; x < this.getWidth(); ++x) {
            for (int y = this.getHeight() - 2; y >= 0; --y) {
                int targetX = MathUtils.clamp(x + RandomGenerator.getInt(-1, 2), 0, this.getWidth() - 1);
                int paletteIndex = this.getFirePixel(targetX, y + 1) - RandomGenerator.getInt(0, 2);
                this.setFirePixel(x, y, paletteIndex);
            }
        }
    }

    private void fadeFire() {
        for (int x = 0; x < this.getWidth(); ++x) {
            int fade = RandomGenerator.getInt(2, 6);
            this.setFirePixel(x, this.getHeight() - 1, this.getFirePixel(x, this.getHeight() - 1) - fade);
        }
    }

    @Override
    public void render(GraphicsContext2D graphics) {
        for (int x = 0; x < this.getWidth(); ++x) {
            for (int y = 0; y < this.getHeight(); ++y) {
                int paletteIndex = this.getFirePixel(x, y);
                if (paletteIndex < 0) continue;
                ColorRGB color = this.palette.get(paletteIndex);
                Rect pixel = new Rect(this.area.getX() + (float)(x * this.pixelSize), this.area.getY() + (float)(y * this.pixelSize), this.pixelSize, this.pixelSize);
                graphics.drawRect(pixel, color);
            }
        }
    }

    private int getWidth() {
        return Math.round(this.area.getWidth() / (float)this.pixelSize);
    }

    private int getHeight() {
        return Math.round(this.area.getHeight() / (float)this.pixelSize);
    }

    private void setFirePixel(int x, int y, int paletteIndex) {
        this.firePixels[y * this.getWidth() + x] = paletteIndex;
    }

    private int getFirePixel(int x, int y) {
        return this.firePixels[y * this.getWidth() + x];
    }
}

