/*
 * Decompiled with CFR 0.152.
 */
package nl.colorize.multimedialib.scene.effect;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import nl.colorize.multimedialib.graphics.Image;
import nl.colorize.multimedialib.graphics.Transform;
import nl.colorize.multimedialib.math.Point2D;
import nl.colorize.multimedialib.math.RandomGenerator;
import nl.colorize.multimedialib.renderer.GraphicsContext2D;
import nl.colorize.multimedialib.scene.effect.Effect;
import nl.colorize.util.animation.Timeline;

public class ParticleEmitter
extends Effect {
    private float duration;
    private List<Effect> particles;
    private List<Image> particleImages;
    private int spawnRate;
    private Point2D spawnOffset;
    private Point2D minVelocity;
    private Point2D maxVelocity;

    public ParticleEmitter(float duration, List<Image> particleImages) {
        super(new Timeline().addKeyFrame(0.0f, 0.0f).addKeyFrame(duration, 1.0f));
        Preconditions.checkArgument((duration > 0.0f ? 1 : 0) != 0, (Object)("Invalid duration: " + duration));
        Preconditions.checkArgument((particleImages.size() >= 1 ? 1 : 0) != 0, (Object)"No particle images");
        this.duration = duration;
        this.particles = new ArrayList<Effect>();
        this.particleImages = ImmutableList.copyOf(particleImages);
        this.spawnRate = 100;
        this.spawnOffset = new Point2D(0.0f, 0.0f);
        this.minVelocity = new Point2D(0.0f, 0.0f);
        this.maxVelocity = new Point2D(0.0f, 0.0f);
    }

    public Point2D getOrigin() {
        return this.getPosition();
    }

    public void setSpawnRate(int spawnRate) {
        this.spawnRate = spawnRate;
    }

    public int getSpawnRate() {
        return this.spawnRate;
    }

    public Point2D getSpawnOffset() {
        return this.spawnOffset;
    }

    public Point2D getMinVelocity() {
        return this.minVelocity;
    }

    public Point2D getMaxVelocity() {
        return this.maxVelocity;
    }

    @Override
    public void update(float deltaTime) {
        super.update(deltaTime);
        int particlesToSpawn = Math.round(deltaTime * (float)this.spawnRate);
        this.spawnParticles(particlesToSpawn);
        for (Effect particle : this.particles) {
            particle.update(deltaTime);
        }
        Iterator<Effect> iterator = this.particles.iterator();
        while (iterator.hasNext()) {
            Effect next = iterator.next();
            if (!next.isCompleted()) continue;
            iterator.remove();
        }
    }

    private void spawnParticles(int count) {
        for (int i = 0; i < count; ++i) {
            Image image = RandomGenerator.pick(this.particleImages);
            float x = this.getOrigin().getX() + RandomGenerator.getFloat(-this.spawnOffset.getX() / 2.0f, this.spawnOffset.getX() / 2.0f);
            float y = this.getOrigin().getY() + RandomGenerator.getFloat(-this.spawnOffset.getY() / 2.0f, this.spawnOffset.getY() / 2.0f);
            int alpha = RandomGenerator.getInt(50, 75);
            Effect particle = Effect.forImage(image, this.duration);
            particle.setPosition(x, y);
            particle.getTransform().setAlpha(alpha);
            particle.modifyFrameUpdate(deltaTime -> this.updateParticle(particle, deltaTime));
            this.particles.add(particle);
        }
    }

    private void updateParticle(Effect particle, float deltaTime) {
        float deltaX;
        if (this.minVelocity.getX() < this.maxVelocity.getX()) {
            deltaX = RandomGenerator.getFloat(this.minVelocity.getX(), this.maxVelocity.getX());
            float deltaY = RandomGenerator.getFloat(this.minVelocity.getY(), this.maxVelocity.getY());
            particle.getPosition().add(deltaX, deltaY);
        } else {
            deltaX = RandomGenerator.getFloat(this.maxVelocity.getX(), this.minVelocity.getX());
            float deltaY = RandomGenerator.getFloat(this.maxVelocity.getY(), this.minVelocity.getY());
            particle.getPosition().add(deltaX, deltaY);
        }
        Transform transform = particle.getTransform();
        transform.setAlpha(Math.max(transform.getAlpha() - 5.0f, 1.0f));
    }

    @Override
    public void render(GraphicsContext2D graphics) {
        for (Effect particle : this.particles) {
            particle.render(graphics);
        }
    }
}

