/*
 * Decompiled with CFR 0.152.
 */
package nl.colorize.multimedialib.scene.ui;

import com.google.common.base.Preconditions;
import java.util.List;
import java.util.function.Consumer;
import nl.colorize.multimedialib.graphics.Align;
import nl.colorize.multimedialib.graphics.Image;
import nl.colorize.multimedialib.graphics.TTFont;
import nl.colorize.multimedialib.math.Rect;
import nl.colorize.multimedialib.renderer.GraphicsContext2D;
import nl.colorize.multimedialib.renderer.InputDevice;
import nl.colorize.multimedialib.scene.ui.Widget;
import nl.colorize.multimedialib.scene.ui.WidgetStyle;

public class SelectBox
extends Widget {
    private List<String> items;
    private String selected;
    private InputDevice input;
    private Consumer<String> onChange;

    public SelectBox(WidgetStyle style, List<String> items, String selected) {
        super(style);
        Preconditions.checkArgument((items.size() > 0 ? 1 : 0) != 0, (Object)"No items provided");
        Preconditions.checkArgument((boolean)items.contains(selected), (Object)"Selected item is not included in the list of items");
        this.items = items;
        this.selected = selected;
    }

    public SelectBox(WidgetStyle style, List<String> items) {
        this(style, items, items.get(0));
    }

    public void setClickHandler(InputDevice input, Consumer<String> onChange) {
        this.input = input;
        this.onChange = onChange;
    }

    private void selectItem(int delta) {
        int index = this.items.indexOf(this.selected) + delta;
        if (index < 0) {
            index = this.items.size() - 1;
        } else if (index >= this.items.size()) {
            index = 0;
        }
        this.selected = this.items.get(index);
        if (this.onChange != null) {
            this.onChange.accept(this.selected);
        }
    }

    @Override
    public void update(float deltaTime) {
        Preconditions.checkArgument((this.input != null ? 1 : 0) != 0, (Object)"Input handler not set");
        Image backgroundImage = this.getStyle().getBackground();
        Rect previousButtonBounds = Rect.around(this.getX() + (float)backgroundImage.getWidth() * 0.3f, this.getY(), (float)backgroundImage.getWidth() * 0.1f, backgroundImage.getHeight());
        Rect nextButtonBounds = Rect.around(this.getX() + (float)backgroundImage.getWidth() * 0.4f, this.getY(), (float)backgroundImage.getWidth() * 0.1f, backgroundImage.getHeight());
        if (this.input.isPointerReleased(previousButtonBounds)) {
            this.selectItem(-1);
        } else if (this.input.isPointerReleased(nextButtonBounds)) {
            this.selectItem(1);
        }
    }

    @Override
    public void render(GraphicsContext2D graphics, WidgetStyle style) {
        Image backgroundImage = style.getBackground();
        TTFont font = style.getFont();
        graphics.drawImage(backgroundImage, this.getX(), this.getY());
        float textY = this.getY() + (float)backgroundImage.getHeight() * 0.2f;
        graphics.drawText(this.selected, font, this.getX() - (float)backgroundImage.getWidth() * 0.4f, textY);
        graphics.drawText("-", font, this.getX() + (float)backgroundImage.getWidth() * 0.3f, textY, Align.CENTER);
        graphics.drawText("+", font, this.getX() + (float)backgroundImage.getWidth() * 0.4f, textY, Align.CENTER);
    }

    public String getSelected() {
        return this.selected;
    }
}

