/*
 * Decompiled with CFR 0.152.
 */
package nl.colorize.multimedialib.demo;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import nl.colorize.multimedialib.graphics.Align;
import nl.colorize.multimedialib.graphics.Animation;
import nl.colorize.multimedialib.graphics.ColorRGB;
import nl.colorize.multimedialib.graphics.Graphic2D;
import nl.colorize.multimedialib.graphics.Image;
import nl.colorize.multimedialib.graphics.OutlineFont;
import nl.colorize.multimedialib.graphics.Primitive;
import nl.colorize.multimedialib.graphics.Sprite;
import nl.colorize.multimedialib.graphics.SpriteSheet;
import nl.colorize.multimedialib.graphics.Text;
import nl.colorize.multimedialib.graphics.Transform;
import nl.colorize.multimedialib.math.Point2D;
import nl.colorize.multimedialib.math.Polygon;
import nl.colorize.multimedialib.math.RandomGenerator;
import nl.colorize.multimedialib.math.Rect;
import nl.colorize.multimedialib.renderer.Audio;
import nl.colorize.multimedialib.renderer.Canvas;
import nl.colorize.multimedialib.renderer.FilePointer;
import nl.colorize.multimedialib.renderer.FrameStats;
import nl.colorize.multimedialib.renderer.InputDevice;
import nl.colorize.multimedialib.renderer.KeyCode;
import nl.colorize.multimedialib.renderer.MediaLoader;
import nl.colorize.multimedialib.renderer.NetworkAccess;
import nl.colorize.multimedialib.scene.DisplayObject;
import nl.colorize.multimedialib.scene.Layer;
import nl.colorize.multimedialib.scene.Scene;
import nl.colorize.multimedialib.scene.SceneContext;
import nl.colorize.multimedialib.scene.Stage;
import nl.colorize.multimedialib.scene.Updatable;
import nl.colorize.multimedialib.scene.effect.Effect;
import nl.colorize.multimedialib.scene.effect.TransitionEffect;
import nl.colorize.util.Callback;
import nl.colorize.util.LogHelper;
import nl.colorize.util.animation.Interpolation;
import nl.colorize.util.animation.Timeline;
import nl.colorize.util.http.Headers;

public class Demo2D
implements Scene {
    private SceneContext context;
    private SpriteSheet marioSpriteSheet;
    private OutlineFont font;
    private List<Mario> marios;
    private Effect colorizeLogo;
    private Audio audioClip;
    private Text hud;
    public static final int DEFAULT_CANVAS_WIDTH = 800;
    public static final int DEFAULT_CANVAS_HEIGHT = 600;
    public static final int DEFAULT_FRAMERATE = 60;
    private static final FilePointer MARIO_SPRITES_FILE = new FilePointer("mario.png");
    private static final FilePointer AUDIO_FILE = new FilePointer("test.mp3");
    private static final FilePointer COLORIZE_LOGO = new FilePointer("colorize-logo.png");
    private static final int INITIAL_MARIOS = 20;
    private static final List<String> DIRECTIONS = ImmutableList.of((Object)"north", (Object)"east", (Object)"south", (Object)"west");
    private static final int BUTTON_WIDTH = 100;
    private static final int BUTTON_HEIGHT = 25;
    private static final ColorRGB RED_BUTTON = new ColorRGB(228, 93, 97);
    private static final ColorRGB GREEN_BUTTON = ColorRGB.parseHex("#72A725");
    private static final ColorRGB BACKGROUND_COLOR = ColorRGB.parseHex("#343434");
    private static final Transform MASK_TRANSFORM = Transform.withMask(ColorRGB.WHITE);
    private static final String TEST_URL = "http://www.colorize.nl";
    private static final ColorRGB COLORIZE_COLOR = ColorRGB.parseHex("#e45d61");
    private static final Logger LOGGER = LogHelper.getLogger(Demo2D.class);

    @Override
    public void start(SceneContext context) {
        this.context = context;
        MediaLoader mediaLoader = context.getMediaLoader();
        context.getStage().setBackgroundColor(BACKGROUND_COLOR);
        this.initMarioSprites(mediaLoader);
        this.marios = new ArrayList<Mario>();
        this.addMarios(context.getStage(), 20);
        this.font = mediaLoader.loadDefaultFont(12, ColorRGB.WHITE);
        this.audioClip = mediaLoader.loadAudio(AUDIO_FILE);
        this.initHUD(context);
        this.initEffects();
    }

    private void initMarioSprites(MediaLoader mediaLoader) {
        Image image = mediaLoader.loadImage(MARIO_SPRITES_FILE);
        this.marioSpriteSheet = new SpriteSheet(image);
        int y = 0;
        for (String direction : ImmutableList.of((Object)"north", (Object)"east", (Object)"south", (Object)"west")) {
            for (int i = 0; i <= 4; ++i) {
                this.marioSpriteSheet.markRegion(direction + "_" + i, new Rect(i * 48, y, 48.0f, 64.0f));
            }
            y += 64;
        }
    }

    private void initHUD(SceneContext context) {
        Stage stage = context.getStage();
        Layer hudLayer = stage.addLayer("hud");
        this.hud = new Text("", this.font);
        this.hud.getPosition().set(20.0f, 20.0f);
        this.hud.setLineHeight(20.0f);
        stage.add("hud", (Graphic2D)this.hud);
        this.createButton(context, "Add sprites", RED_BUTTON, 0, () -> this.addMarios(stage, 10));
        this.createButton(context, "Remove sprites", RED_BUTTON, 30, () -> this.removeMarios(10));
        this.createButton(context, "Play sound", GREEN_BUTTON, 60, this.audioClip::play);
        this.createButton(context, "Background", GREEN_BUTTON, 90, () -> this.toggleBackgroundColor(stage));
        Polygon hexagon = new Polygon(80.0f, 70.0f, 120.0f, 70.0f, 135.0f, 100.0f, 120.0f, 130.0f, 80.0f, 130.0f, 65.0f, 100.0f);
        Primitive hexagonPrimitive = Primitive.of(hexagon, COLORIZE_COLOR);
        hexagonPrimitive.setAlpha(50.0f);
        new DisplayObject().withGraphics(hexagonPrimitive).withLayer(hudLayer).withFrameHandler(deltaTime -> hexagonPrimitive.setPosition(50.0f, (float)stage.getCanvas().getHeight() - 150.0f)).attachTo(context);
    }

    private void createButton(SceneContext context, String label, ColorRGB color, int y, Runnable click) {
        Primitive bounds = Primitive.of(new Rect(context.getCanvas().getWidth() - 100 - 2, y + 2, 100.0f, 25.0f), color);
        Text text = new Text(label, this.font, Align.CENTER);
        text.getPosition().set((float)context.getCanvas().getWidth() - 50.0f, y + 19);
        new DisplayObject().withGraphics(bounds, text).withLayer(context.getStage().getLayer("hud")).withClickHandler(click).attachTo(context);
    }

    private void initEffects() {
        Timeline timeline = new Timeline(Interpolation.LINEAR, true);
        timeline.addKeyFrame(0.0f, 0.0f);
        timeline.addKeyFrame(2.0f, 1.0f);
        timeline.addKeyFrame(4.0f, 0.0f);
        this.colorizeLogo = Effect.forImage(this.context.getMediaLoader().loadImage(COLORIZE_LOGO), timeline);
        Transform transform = this.colorizeLogo.getTransform();
        this.colorizeLogo.modify(value -> this.colorizeLogo.setPosition(50.0f, this.context.getCanvas().getHeight() - 50));
        this.colorizeLogo.modify(value -> transform.setScale(80 + Math.round(value.floatValue() * 40.0f)));
        this.colorizeLogo.modifyFrameUpdate(dt -> transform.addRotation(Math.round(dt * 100.0f)));
        this.colorizeLogo.attachTo(this.context);
        TransitionEffect.reveal(this.context, COLORIZE_COLOR, 1.5f).attachTo(this.context);
    }

    private void toggleBackgroundColor(Stage stage) {
        if (stage.getBackgroundColor().equals(BACKGROUND_COLOR)) {
            stage.setBackgroundColor(ColorRGB.WHITE);
        } else {
            stage.setBackgroundColor(BACKGROUND_COLOR);
        }
    }

    @Override
    public void update(SceneContext context, float deltaTime) {
        InputDevice inputDevice = context.getInputDevice();
        this.handleClick(inputDevice, context.getStage());
        this.checkLogoClick(inputDevice);
        this.handleSystemControls(inputDevice, context.getNetwork());
        for (Mario mario : this.marios) {
            this.updateMario(mario, deltaTime);
        }
        this.updateHUD();
    }

    private void updateMario(Mario mario, float deltaTime) {
        mario.update(deltaTime);
        mario.sprite.setPosition(mario.position);
        mario.sprite.setTransform(mario.mask ? MASK_TRANSFORM : null);
    }

    private void updateHUD() {
        FrameStats stats = this.context.getFrameStats();
        this.hud.setText("Canvas:  " + this.context.getCanvas(), "Framerate:  " + Math.round(stats.getFramerate()), "Update time:  " + stats.getUpdateTime() + "ms", "Render time:  " + stats.getRenderTime() + "ms", "Sprites:  " + this.marios.size());
    }

    private void checkLogoClick(InputDevice input) {
        Rect area = new Rect(0.0f, (float)this.context.getCanvas().getHeight() - 80.0f, 80.0f, 80.0f);
        if (input.isPointerReleased(area)) {
            Transform transform;
            transform.setFlipHorizontal(!(transform = this.colorizeLogo.getTransform()).isFlipHorizontal());
        }
    }

    private void handleClick(InputDevice inputDevice, Stage stage) {
        if (this.checkMarioClick(inputDevice)) {
            return;
        }
        if (inputDevice.isPointerReleased(stage.getCanvas().getBounds())) {
            this.createTouchMarker(inputDevice.getPointers());
        }
    }

    private boolean checkMarioClick(InputDevice inputDevice) {
        for (Mario mario : this.marios) {
            if (!inputDevice.isPointerReleased(mario.getBounds())) continue;
            mario.mask = !mario.mask;
            return true;
        }
        return false;
    }

    private void handleSystemControls(InputDevice input, NetworkAccess network) {
        if (input.isKeyReleased(KeyCode.U)) {
            this.sendRequest(network);
        }
        ImmutableList canvasControls = ImmutableList.of((Object)((Object)KeyCode.N1), (Object)((Object)KeyCode.N2), (Object)((Object)KeyCode.N3), (Object)((Object)KeyCode.N4));
        for (int i = 0; i < canvasControls.size(); ++i) {
            if (!input.isKeyReleased((KeyCode)((Object)canvasControls.get(i)))) continue;
            this.changeCanvasStrategy(i);
        }
    }

    private void changeCanvasStrategy(int index) {
        Canvas.ZoomStrategy strategy = Canvas.ZoomStrategy.values()[index];
        LOGGER.info("Changing canvas zoom strategy to " + strategy);
        this.context.getCanvas().changeStrategy(strategy);
    }

    private void createTouchMarker(List<Point2D> positions) {
        for (Point2D position : positions) {
            Timeline timeline = new Timeline();
            timeline.addKeyFrame(0.0f, 100.0f);
            timeline.addKeyFrame(1.0f, 100.0f);
            timeline.addKeyFrame(1.5f, 0.0f);
            String text = Math.round(position.getX()) + ", " + Math.round(position.getY());
            Effect.forTextAlpha(text, this.font, Align.LEFT, timeline).setPosition(position).attachTo(this.context);
        }
    }

    public void addMarios(Stage stage, int amount) {
        for (int i = 0; i < amount; ++i) {
            Sprite marioSprite = this.createMarioSprite();
            Mario mario = new Mario(marioSprite, new Rect(0.0f, 0.0f, this.context.getCanvas().getWidth(), this.context.getCanvas().getHeight()));
            this.marios.add(mario);
            this.updateMario(mario, 0.0f);
            stage.add(marioSprite);
        }
    }

    private Sprite createMarioSprite() {
        Sprite marioSprite = new Sprite();
        for (String direction : DIRECTIONS) {
            List<Image> frames = this.marioSpriteSheet.get(direction + "_0", direction + "_1", direction + "_2", direction + "_3", direction + "_4");
            Animation anim = new Animation(frames, 0.1f, true);
            marioSprite.addState(direction, anim);
        }
        return marioSprite;
    }

    private void removeMarios(int amount) {
        for (int i = 0; i < amount && !this.marios.isEmpty(); ++i) {
            this.marios.remove(this.marios.size() - 1);
        }
    }

    private void sendRequest(NetworkAccess internetAccess) {
        LOGGER.info("Sending request to http://www.colorize.nl");
        Headers headers = new Headers();
        headers.add("X-Do-Not-Track", "1");
        internetAccess.get(TEST_URL, headers, (Callback<String>)Callback.from(LOGGER::info, (Logger)LOGGER));
    }

    private static class Mario
    implements Updatable {
        private Sprite sprite;
        private Rect canvasBounds;
        private Point2D position;
        private int direction;
        private float speed;
        private boolean mask;

        public Mario(Sprite sprite, Rect canvasBounds) {
            this.sprite = sprite;
            this.position = new Point2D(RandomGenerator.getFloat(0.0f, canvasBounds.getWidth()), RandomGenerator.getFloat(0.0f, canvasBounds.getHeight()));
            this.canvasBounds = canvasBounds;
            this.direction = RandomGenerator.getInt(0, 4);
            this.speed = RandomGenerator.getFloat(20.0f, 80.0f);
            this.mask = false;
        }

        @Override
        public void update(float deltaTime) {
            this.sprite.changeState(DIRECTIONS.get(this.direction));
            this.sprite.update(deltaTime);
            switch (this.direction) {
                case 0: {
                    this.position.add(0.0f, -this.speed * deltaTime);
                    break;
                }
                case 1: {
                    this.position.add(this.speed * deltaTime, 0.0f);
                    break;
                }
                case 2: {
                    this.position.add(0.0f, this.speed * deltaTime);
                    break;
                }
                case 3: {
                    this.position.add(-this.speed * deltaTime, 0.0f);
                    break;
                }
                default: {
                    throw new AssertionError();
                }
            }
            this.checkBounds();
        }

        private void checkBounds() {
            if (this.position.getX() < 0.0f || this.position.getX() > this.canvasBounds.getWidth() || this.position.getY() < 0.0f || this.position.getY() > this.canvasBounds.getHeight()) {
                this.direction = (this.direction + 2) % 4;
            }
        }

        private Rect getBounds() {
            return new Rect(this.position.getX() - (float)this.sprite.getCurrentWidth() / 2.0f, this.position.getY() - (float)this.sprite.getCurrentHeight() / 2.0f, this.sprite.getCurrentWidth(), this.sprite.getCurrentHeight());
        }
    }
}

