/*
 * Decompiled with CFR 0.152.
 */
package nl.colorize.multimedialib.demo;

import nl.colorize.multimedialib.demo.Demo2D;
import nl.colorize.multimedialib.demo.Demo3D;
import nl.colorize.multimedialib.renderer.Canvas;
import nl.colorize.multimedialib.renderer.DisplayMode;
import nl.colorize.multimedialib.renderer.Renderer;
import nl.colorize.multimedialib.renderer.WindowOptions;
import nl.colorize.multimedialib.scene.ErrorHandler;
import nl.colorize.multimedialib.scene.MultimediaAppLauncher;
import nl.colorize.multimedialib.scene.Scene;
import nl.colorize.util.cli.CommandLineArgumentParser;
import nl.colorize.util.swing.ApplicationMenuListener;
import nl.colorize.util.swing.Popups;

public class DemoLauncher
implements ApplicationMenuListener {
    private String rendererName;
    private String graphics;
    private int framerate;
    private boolean canvas;

    public static void main(String[] args) {
        CommandLineArgumentParser argParser = new CommandLineArgumentParser("DemoLauncher").add("-renderer", "Renderer to use for the demo (java2d, gdx)").add("-graphics", "Either '2d' or '3d'").addOptional("-framerate", "60", "Demo framerate, default is 60 fps").addFlag("-canvas", "Uses a fixed canvas size to display graphics");
        argParser.parseArgs(args);
        DemoLauncher demo = new DemoLauncher();
        demo.rendererName = argParser.get("renderer");
        demo.graphics = argParser.get("graphics");
        demo.framerate = argParser.getInt("framerate");
        demo.canvas = argParser.getBool("canvas");
        demo.start();
    }

    private void start() {
        DisplayMode displayMode = new DisplayMode(this.getCanvas(), this.framerate);
        WindowOptions window = new WindowOptions("MultimediaLib - Demo", WindowOptions.DEFAULT_ICON, this);
        Renderer renderer = switch (this.rendererName) {
            case "java2d" -> MultimediaAppLauncher.launchJava2D(displayMode, window);
            case "libgdx", "gdx" -> MultimediaAppLauncher.launchGDX(displayMode, window);
            default -> throw new UnsupportedOperationException("Unsupported renderer: " + this.rendererName);
        };
        Scene demo = this.createDemoScene();
        renderer.start(demo, ErrorHandler.DEFAULT);
    }

    private Scene createDemoScene() {
        return switch (this.graphics) {
            case "2d" -> new Demo2D();
            case "3d" -> new Demo3D();
            default -> throw new UnsupportedOperationException("Unknown graphics mode: " + this.graphics);
        };
    }

    private Canvas getCanvas() {
        if (this.canvas) {
            return Canvas.zoomOut(800, 600);
        }
        return Canvas.flexible(800, 600);
    }

    public void onQuit() {
        System.exit(0);
    }

    public void onAbout() {
        Popups.message(null, (String)"MultimediaLib - demo application");
    }

    public boolean hasPreferencesMenu() {
        return false;
    }

    public void onPreferences() {
    }
}

