/*
 * Decompiled with CFR 0.152.
 */
package nl.colorize.multimedialib.graphics;

import nl.colorize.multimedialib.graphics.ColorRGB;
import nl.colorize.multimedialib.graphics.Graphic2D;
import nl.colorize.multimedialib.math.Circle;
import nl.colorize.multimedialib.math.Line;
import nl.colorize.multimedialib.math.MathUtils;
import nl.colorize.multimedialib.math.Point2D;
import nl.colorize.multimedialib.math.Polygon;
import nl.colorize.multimedialib.math.Rect;
import nl.colorize.multimedialib.math.Shape;

public class Primitive
implements Graphic2D {
    private Shape shape;
    private ColorRGB color;
    private Point2D position;
    private float alpha;
    private boolean visible;
    public static final int TYPE_LINE = 1;
    public static final int TYPE_RECT = 2;
    public static final int TYPE_CIRCLE = 3;
    public static final int TYPE_POLYGON = 4;

    private Primitive(Shape shape, ColorRGB color) {
        this.shape = shape;
        this.color = color;
        this.position = new Point2D(0.0f, 0.0f);
        this.alpha = 100.0f;
        this.visible = true;
    }

    public Shape getShape() {
        return this.shape;
    }

    public int getShapeType() {
        if (this.shape instanceof Line) {
            return 1;
        }
        if (this.shape instanceof Rect) {
            return 2;
        }
        if (this.shape instanceof Circle) {
            return 3;
        }
        if (this.shape instanceof Polygon) {
            return 4;
        }
        throw new IllegalStateException("Unknown shape: " + this.shape.getClass());
    }

    public void setColor(ColorRGB color) {
        this.color = color;
    }

    public ColorRGB getColor() {
        return this.color;
    }

    public void setAlpha(float alpha) {
        this.alpha = MathUtils.clamp(alpha, 0.0f, 100.0f);
    }

    public float getAlpha() {
        return this.alpha;
    }

    public void setVisible(boolean visible) {
        this.visible = visible;
    }

    @Override
    public boolean isVisible() {
        return this.visible;
    }

    @Override
    public Point2D getPosition() {
        return this.position;
    }

    @Override
    public void update(float deltaTime) {
    }

    @Override
    public Rect getBounds() {
        return this.shape.reposition(this.position).getBoundingBox();
    }

    @Override
    public boolean hitTest(Point2D point) {
        return this.shape.reposition(this.position).contains(point);
    }

    public static Primitive of(Shape shape, ColorRGB color) {
        return new Primitive(shape, color);
    }

    public static Primitive of(Shape shape, ColorRGB color, float alpha) {
        Primitive result = Primitive.of(shape, color);
        result.setAlpha(alpha);
        return result;
    }
}

