/*
 * Decompiled with CFR 0.152.
 */
package nl.colorize.multimedialib.graphics;

import com.google.common.base.Preconditions;
import java.util.Set;
import java.util.stream.Collectors;
import nl.colorize.multimedialib.graphics.Animation;
import nl.colorize.multimedialib.graphics.Graphic2D;
import nl.colorize.multimedialib.graphics.Image;
import nl.colorize.multimedialib.graphics.Transform;
import nl.colorize.multimedialib.math.Point2D;
import nl.colorize.multimedialib.math.Rect;
import nl.colorize.multimedialib.scene.SimpleState;
import nl.colorize.multimedialib.scene.StateMachine;

public class Sprite
implements Graphic2D {
    private StateMachine<SpriteState> stateMachine = new StateMachine();
    private Point2D position = new Point2D(0.0f, 0.0f);
    private Transform transform = new Transform();
    private boolean visible = true;
    private Rect cachedBounds = new Rect(0.0f, 0.0f, 0.0f, 0.0f);
    private static final String DEFAULT_STATE = "$$default";

    public Sprite() {
    }

    public Sprite(Animation anim) {
        this();
        this.addState(DEFAULT_STATE, anim);
    }

    public Sprite(Image image) {
        this();
        this.addState(DEFAULT_STATE, image);
    }

    public void addState(String name, Animation graphics) {
        SpriteState state = new SpriteState(name, graphics);
        this.stateMachine.register(state);
    }

    public void addState(String name, Image stateGraphics) {
        this.addState(name, new Animation(stateGraphics));
    }

    @Override
    public void update(float deltaTime) {
        this.stateMachine.update(deltaTime);
        SpriteState activeState = this.stateMachine.getActiveState();
        Preconditions.checkState((activeState != null ? 1 : 0) != 0, (Object)"Sprite is not active");
        Preconditions.checkState((activeState.graphics != null ? 1 : 0) != 0, (Object)"Sprite does not have graphics");
    }

    public void changeState(String stateName) {
        SpriteState newState = this.stateMachine.getPossibleState(stateName);
        this.stateMachine.changeState(newState);
    }

    public void resetState() {
        this.stateMachine.resetActiveState();
    }

    public String getActiveState() {
        return this.stateMachine.getActiveState().getName();
    }

    public float getTimeInActiveState() {
        return this.stateMachine.getActiveStateTime();
    }

    public Set<String> getPossibleStates() {
        return this.stateMachine.getPossibleStates().stream().map(state -> state.getName()).collect(Collectors.toSet());
    }

    public boolean hasState(String stateName) {
        return this.stateMachine.hasState(stateName);
    }

    public Animation getStateGraphics(String stateName) {
        return this.stateMachine.getPossibleState((String)stateName).graphics;
    }

    public Animation getActiveStateGraphics() {
        return this.getStateGraphics(this.getActiveState());
    }

    public Image getCurrentGraphics() {
        SpriteState activeState = this.stateMachine.getActiveState();
        return activeState.graphics.getFrameAtTime(this.stateMachine.getActiveStateTime());
    }

    public int getCurrentWidth() {
        return this.getCurrentGraphics().getWidth();
    }

    public int getCurrentHeight() {
        return this.getCurrentGraphics().getHeight();
    }

    @Override
    public void setPosition(Point2D p) {
        this.position.set(p);
    }

    @Override
    public void setPosition(float x, float y) {
        this.position.set(x, y);
    }

    @Override
    public Point2D getPosition() {
        return this.position;
    }

    public void setTransform(Transform transform) {
        if (transform == null) {
            transform = new Transform();
        }
        this.transform = transform;
    }

    public Transform getTransform() {
        return this.transform;
    }

    public void setVisible(boolean visible) {
        this.visible = visible;
    }

    @Override
    public boolean isVisible() {
        return this.visible;
    }

    @Override
    public Rect getBounds() {
        float width = Math.max((float)this.getCurrentWidth() * (this.transform.getScaleX() / 100.0f), 1.0f);
        float height = Math.max((float)this.getCurrentHeight() * (this.transform.getScaleY() / 100.0f), 1.0f);
        this.cachedBounds.set(this.position.getX() - width / 2.0f, this.position.getY() - height / 2.0f, width, height);
        return this.cachedBounds;
    }

    public void scaleTo(float width, float height) {
        float scaleX = width / (float)this.getCurrentWidth() * 100.0f;
        float scaleY = height / (float)this.getCurrentHeight() * 100.0f;
        this.transform.setScale(scaleX, scaleY);
    }

    @Override
    public boolean hitTest(Point2D point) {
        return this.getBounds().contains(point);
    }

    public Sprite copy() {
        Sprite copy = new Sprite();
        for (SpriteState state : this.stateMachine.getPossibleStates()) {
            copy.addState(state.getName(), state.graphics);
        }
        copy.changeState(this.stateMachine.getActiveState().getName());
        copy.setPosition(this.position.copy());
        copy.setTransform(this.transform.copy());
        return copy;
    }

    private static class SpriteState
    extends SimpleState {
        private Animation graphics;

        public SpriteState(String name, Animation graphics) {
            super(name, 0.0f, null, true);
            this.graphics = graphics;
        }
    }
}

