/*
 * Decompiled with CFR 0.152.
 */
package nl.colorize.multimedialib.math;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.function.Function;

public class Cache<K, V> {
    private LinkedList<K> keys;
    private Map<K, V> entries;
    private Function<K, V> loader;
    private int capacity;

    public Cache(Function<K, V> loader, int capacity) {
        Preconditions.checkArgument((capacity >= 1 ? 1 : 0) != 0, (Object)"Invalid cache capacity");
        this.keys = new LinkedList();
        this.entries = new HashMap();
        this.loader = loader;
        this.capacity = capacity;
    }

    public V get(K key) {
        if (this.entries.containsKey(key)) {
            return this.entries.get(key);
        }
        V value = this.loader.apply(key);
        this.entries.put(key, value);
        this.keys.add(key);
        if (this.keys.size() > this.capacity) {
            K evicted = this.keys.removeFirst();
            this.entries.remove(evicted);
        }
        return value;
    }

    @VisibleForTesting
    protected boolean isCached(K key) {
        return this.entries.containsKey(key);
    }

    public void invalidate(K key) {
        this.entries.remove(key);
    }

    public void invalidateAll() {
        this.entries.clear();
    }

    public static <K, V> Cache<K, V> create(Function<K, V> loader, int capacity) {
        return new Cache<K, V>(loader, capacity);
    }

    public static <K, V> Cache<K, V> createUnlimited(Function<K, V> loader) {
        return new Cache<K, V>(loader, Integer.MAX_VALUE);
    }
}

