/*
 * Decompiled with CFR 0.152.
 */
package nl.colorize.multimedialib.math;

import com.google.common.base.Preconditions;
import java.util.Objects;
import nl.colorize.multimedialib.math.Point2D;
import nl.colorize.multimedialib.math.Rect;
import nl.colorize.multimedialib.math.Shape;

public class Circle
implements Shape {
    private Point2D center;
    private float radius;

    public Circle(Point2D center, float radius) {
        Preconditions.checkArgument((radius > 0.0f ? 1 : 0) != 0, (Object)("Invalid radius: " + radius));
        this.center = center.copy();
        this.radius = radius;
    }

    public Circle(float x, float y, float radius) {
        this(new Point2D(x, y), radius);
    }

    public Point2D getCenter() {
        return this.center;
    }

    public float getCenterX() {
        return this.center.getX();
    }

    public float getCenterY() {
        return this.center.getY();
    }

    public float getRadius() {
        return this.radius;
    }

    public float getDiameter() {
        return this.radius * 2.0f;
    }

    @Override
    public boolean contains(Point2D p) {
        return this.calculateDistance(p) <= this.radius;
    }

    public boolean intersects(Circle other) {
        return this.calculateDistance(other) <= this.radius + other.radius;
    }

    public float calculateDistance(Point2D p) {
        return this.center.distanceTo(p);
    }

    public float calculateDistance(Circle other) {
        return this.center.distanceTo(other.center);
    }

    @Override
    public Rect getBoundingBox() {
        return new Rect(this.center.getX() - this.radius, this.center.getY() - this.radius, 2.0f * this.radius, 2.0f * this.radius);
    }

    @Override
    public Circle copy() {
        return new Circle(this.center.copy(), this.radius);
    }

    @Override
    public Circle reposition(Point2D offset) {
        Circle result = this.copy();
        result.center.add(offset);
        return result;
    }

    public boolean equals(Object o) {
        if (o instanceof Circle) {
            Circle other = (Circle)o;
            return Math.abs(this.center.getX() - other.center.getX()) < 0.001f && Math.abs(this.center.getY() - other.center.getY()) < 0.001f && Math.abs(this.radius - other.radius) < 0.001f;
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(Float.valueOf(this.center.getX()), Float.valueOf(this.center.getY()), Float.valueOf(this.radius));
    }
}

