/*
 * Decompiled with CFR 0.152.
 */
package nl.colorize.multimedialib.math;

import nl.colorize.multimedialib.math.Point2D;
import nl.colorize.multimedialib.math.Rect;
import nl.colorize.multimedialib.math.Shape;

public class Line
implements Shape {
    private Point2D start;
    private Point2D end;
    private int thickness;

    public Line(Point2D start, Point2D end, int thickness) {
        this.start = start;
        this.end = end;
        this.thickness = thickness;
    }

    public Point2D getStart() {
        return this.start;
    }

    public Point2D getEnd() {
        return this.end;
    }

    public int getThickness() {
        return this.thickness;
    }

    @Override
    public boolean contains(Point2D p) {
        return p.equals(this.start) || p.equals(this.end);
    }

    @Override
    public Rect getBoundingBox() {
        float x0 = Math.min(this.start.getX(), this.end.getX());
        float y0 = Math.min(this.start.getY(), this.end.getY());
        float x1 = Math.max(this.start.getX(), this.end.getX());
        float y1 = Math.max(this.start.getY(), this.end.getY());
        return Rect.fromPoints(x0, y0, x1, y1);
    }

    @Override
    public Line copy() {
        return new Line(this.start.copy(), this.end.copy(), this.thickness);
    }

    @Override
    public Line reposition(Point2D offset) {
        Line result = this.copy();
        result.start.add(offset);
        result.end.add(offset);
        return result;
    }

    public String toString() {
        return this.start + ", " + this.end;
    }
}

