/*
 * Decompiled with CFR 0.152.
 */
package nl.colorize.multimedialib.math;

import com.google.common.base.Preconditions;
import java.util.Objects;
import nl.colorize.multimedialib.math.Point2D;
import nl.colorize.multimedialib.math.Polygon;
import nl.colorize.multimedialib.math.Shape;

public class Rect
implements Shape {
    private float x;
    private float y;
    private float width;
    private float height;

    public Rect(float x, float y, float width, float height) {
        this.set(x, y, width, height);
    }

    public float getX() {
        return this.x;
    }

    public void setX(float x) {
        this.x = x;
    }

    public float getY() {
        return this.y;
    }

    public void setY(float y) {
        this.y = y;
    }

    public float getWidth() {
        return this.width;
    }

    public void setWidth(float width) {
        Preconditions.checkArgument((width >= 0.0f ? 1 : 0) != 0, (String)"Invalid width: %s", (Object)Float.valueOf(width));
        this.width = width;
    }

    public float getHeight() {
        return this.height;
    }

    public void setHeight(float height) {
        Preconditions.checkArgument((height >= 0.0f ? 1 : 0) != 0, (String)"Invalid height: %s", (Object)Float.valueOf(height));
        this.height = height;
    }

    public float getCenterX() {
        return this.x + this.width / 2.0f;
    }

    public float getCenterY() {
        return this.y + this.height / 2.0f;
    }

    public float getEndX() {
        return this.x + this.width;
    }

    public float getEndY() {
        return this.y + this.height;
    }

    public Point2D getTopLeft() {
        return new Point2D(this.x, this.y);
    }

    public Point2D getTopRight() {
        return new Point2D(this.getEndX(), this.y);
    }

    public Point2D getBottomLeft() {
        return new Point2D(this.x, this.getEndY());
    }

    public Point2D getBottomRight() {
        return new Point2D(this.getEndX(), this.getEndY());
    }

    public Point2D getCenter() {
        return new Point2D(this.getCenterX(), this.getCenterY());
    }

    public void set(float x, float y, float width, float height) {
        this.setX(x);
        this.setY(y);
        this.setWidth(width);
        this.setHeight(height);
    }

    public void set(Rect r) {
        this.set(r.getX(), r.getY(), r.getWidth(), r.getHeight());
    }

    public void move(Point2D delta) {
        this.x += delta.getX();
        this.y += delta.getY();
    }

    @Override
    public boolean contains(Point2D p) {
        return this.contains(p.getX(), p.getY());
    }

    public boolean contains(float px, float py) {
        return px >= this.x && px <= this.x + this.width && py >= this.y && py <= this.y + this.height;
    }

    public boolean contains(Rect r) {
        return r.x >= this.x && r.x + r.width <= this.x + this.width && r.y >= this.y && r.y + r.height <= this.y + this.height;
    }

    public boolean intersects(Rect r) {
        return !(r.x + r.width < this.x || r.x > this.x + this.width || r.y + r.height < this.y || r.y > this.y + this.height);
    }

    @Override
    public Rect getBoundingBox() {
        return this.copy();
    }

    @Override
    public Rect copy() {
        return new Rect(this.x, this.y, this.width, this.height);
    }

    @Override
    public Rect reposition(Point2D offset) {
        Rect result = this.copy();
        result.x += offset.getX();
        result.y += offset.getY();
        return result;
    }

    public Polygon toPolygon() {
        return new Polygon(this.x, this.y, this.x + this.width, this.y, this.x + this.width, this.y + this.height, this.x, this.y + this.height);
    }

    public boolean equals(Object o) {
        if (o instanceof Rect) {
            Rect other = (Rect)o;
            return Math.abs(this.x - other.x) < 0.001f && Math.abs(this.y - other.y) < 0.001f && Math.abs(this.width - other.width) < 0.001f && Math.abs(this.height - other.height) < 0.001f;
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(Float.valueOf(this.x), Float.valueOf(this.y), Float.valueOf(this.width), Float.valueOf(this.height));
    }

    public String toString() {
        return Math.round(this.x) + ", " + Math.round(this.y) + ", " + Math.round(this.width) + ", " + Math.round(this.height);
    }

    public static Rect fromPoints(float x0, float y0, float x1, float y1) {
        return new Rect(x0, y0, x1 - x0, y1 - y0);
    }

    public static Rect around(float x, float y, float width, float height) {
        return Rect.around(new Point2D(x, y), width, height);
    }

    public static Rect around(Point2D center, float width, float height) {
        return new Rect(center.getX() - width / 2.0f, center.getY() - height / 2.0f, width, height);
    }
}

