/*
 * Decompiled with CFR 0.152.
 */
package nl.colorize.multimedialib.renderer;

import com.google.common.base.Preconditions;
import nl.colorize.multimedialib.graphics.Graphic2D;
import nl.colorize.multimedialib.math.Point2D;
import nl.colorize.multimedialib.math.Rect;

public class Canvas {
    private int preferredWidth;
    private int preferredHeight;
    private ZoomStrategy zoomStrategy;
    private int screenWidth;
    private int screenHeight;
    private int offsetX;
    private int offsetY;

    public Canvas(int preferredWidth, int preferredHeight, ZoomStrategy zoomStrategy) {
        this.resize(preferredWidth, preferredHeight);
        this.zoomStrategy = zoomStrategy;
        this.screenWidth = preferredWidth;
        this.screenHeight = preferredHeight;
        this.offsetX = 0;
        this.offsetY = 0;
    }

    public void changeStrategy(ZoomStrategy zoomStrategy) {
        this.zoomStrategy = zoomStrategy;
    }

    public void resize(int preferredWidth, int preferredHeight) {
        Preconditions.checkArgument((preferredWidth > 0 && preferredHeight > 0 ? 1 : 0) != 0, (Object)("Invalid canvas dimensions: " + preferredWidth + "x" + preferredHeight));
        this.preferredWidth = preferredWidth;
        this.preferredHeight = preferredHeight;
    }

    public void resizeScreen(int screenWidth, int screenHeight) {
        Preconditions.checkArgument((screenWidth > 0 && screenHeight > 0 ? 1 : 0) != 0, (Object)("Invalid screen dimensions: " + screenWidth + "x" + screenHeight));
        this.screenWidth = screenWidth;
        this.screenHeight = screenHeight;
    }

    public void offsetScreen(int offsetX, int offsetY) {
        this.offsetX = offsetX;
        this.offsetY = offsetY;
    }

    public int getWidth() {
        return Math.round((float)this.screenWidth / this.getZoomLevel());
    }

    public int getHeight() {
        return Math.round((float)this.screenHeight / this.getZoomLevel());
    }

    public Rect getBounds() {
        return new Rect(0.0f, 0.0f, this.getWidth(), this.getHeight());
    }

    public Point2D getCenter() {
        return new Point2D((float)this.getWidth() / 2.0f, (float)this.getHeight() / 2.0f);
    }

    public float getZoomLevel() {
        float horizontalZoom = (float)this.screenWidth / (float)this.preferredWidth;
        float verticalZoom = (float)this.screenHeight / (float)this.preferredHeight;
        switch (this.zoomStrategy) {
            case FLEXIBLE: {
                return 1.0f;
            }
            case ZOOM_IN: {
                return Math.max(horizontalZoom, verticalZoom);
            }
            case ZOOM_OUT: {
                return Math.min(horizontalZoom, verticalZoom);
            }
            case ZOOM_BALANCED: {
                return (horizontalZoom + verticalZoom) / 2.0f;
            }
        }
        throw new AssertionError();
    }

    public float toCanvasX(int screenX) {
        return (float)(screenX - this.offsetX) / this.getZoomLevel();
    }

    public float toCanvasX(Point2D point) {
        return this.toCanvasX(Math.round(point.getX()));
    }

    public float toCanvasY(int screenY) {
        return (float)(screenY - this.offsetY) / this.getZoomLevel();
    }

    public float toCanvasY(Point2D point) {
        return this.toCanvasY(Math.round(point.getY()));
    }

    public float toScreenX(float canvasX) {
        return canvasX * this.getZoomLevel() + (float)this.offsetX;
    }

    public float toScreenX(Point2D point) {
        return this.toScreenX(point.getX());
    }

    public float toScreenY(float canvasY) {
        return canvasY * this.getZoomLevel() + (float)this.offsetY;
    }

    public float toScreenY(Point2D point) {
        return this.toScreenY(point.getY());
    }

    public boolean isVisible(Graphic2D graphic) {
        Rect canvasBounds = this.getBounds();
        return graphic.isVisible() && graphic.getBounds().intersects(canvasBounds);
    }

    public String toString() {
        return this.getWidth() + "x" + this.getHeight();
    }

    public static Canvas flexible(int initialWidth, int initialHeight) {
        return new Canvas(initialWidth, initialHeight, ZoomStrategy.FLEXIBLE);
    }

    @Deprecated
    public static Canvas fixed(int preferredWidth, int preferredHeight) {
        return Canvas.zoomOut(preferredWidth, preferredHeight);
    }

    public static Canvas zoomIn(int preferredWidth, int preferredHeight) {
        return new Canvas(preferredWidth, preferredHeight, ZoomStrategy.ZOOM_IN);
    }

    public static Canvas zoomOut(int preferredWidth, int preferredHeight) {
        return new Canvas(preferredWidth, preferredHeight, ZoomStrategy.ZOOM_OUT);
    }

    public static Canvas zoomBalanced(int preferredWidth, int preferredHeight) {
        return new Canvas(preferredWidth, preferredHeight, ZoomStrategy.ZOOM_BALANCED);
    }

    public static enum ZoomStrategy {
        FLEXIBLE,
        ZOOM_IN,
        ZOOM_OUT,
        ZOOM_BALANCED;

    }
}

