/*
 * Decompiled with CFR 0.152.
 */
package nl.colorize.multimedialib.renderer;

import com.google.common.annotations.VisibleForTesting;
import nl.colorize.util.Stopwatch;

public class FrameStats {
    private Stopwatch timer;
    private int targetFramerate;
    private long currentFrameUpdateTime;
    private long currentFrameRenderTime;
    private float framerate;
    private long updateTime;
    private long renderTime;
    private static final float WEIGHT = 0.9f;

    public FrameStats(int targetFramerate) {
        this(new Stopwatch(), targetFramerate);
    }

    @VisibleForTesting
    protected FrameStats(Stopwatch timer, int targetFramerate) {
        this.timer = timer;
        this.targetFramerate = targetFramerate;
    }

    public void markFrameStart() {
        long frameTime = this.timer.tick();
        float currentFramerate = 1.0f / ((float)frameTime / 1000.0f);
        if (this.updateTime == 0L) {
            this.framerate = currentFramerate;
            this.updateTime = this.currentFrameUpdateTime;
            this.renderTime = this.currentFrameRenderTime;
        } else {
            this.framerate = 0.9f * this.framerate + 0.100000024f * currentFramerate;
            this.updateTime = Math.round(0.9f * (float)this.updateTime + 0.100000024f * (float)this.currentFrameUpdateTime);
            this.renderTime = Math.round(0.9f * (float)this.renderTime + 0.100000024f * (float)this.currentFrameRenderTime);
        }
    }

    public void markFrameUpdate() {
        this.currentFrameUpdateTime = this.timer.tock();
    }

    public void markFrameRender() {
        this.currentFrameRenderTime = Math.max(this.timer.tock() - this.currentFrameUpdateTime, 0L);
    }

    public int getTargetFramerate() {
        return this.targetFramerate;
    }

    public float getFramerate() {
        return this.framerate;
    }

    public long getUpdateTime() {
        return this.updateTime;
    }

    public long getRenderTime() {
        return this.renderTime;
    }
}

