/*
 * Decompiled with CFR 0.152.
 */
package nl.colorize.multimedialib.renderer.headless;

import com.google.common.annotations.VisibleForTesting;
import nl.colorize.multimedialib.graphics.FontStyle;
import nl.colorize.multimedialib.graphics.Image;
import nl.colorize.multimedialib.graphics.OutlineFont;
import nl.colorize.multimedialib.renderer.FilePointer;
import nl.colorize.multimedialib.renderer.headless.HeadlessFont;
import nl.colorize.multimedialib.renderer.headless.HeadlessImage;
import nl.colorize.multimedialib.renderer.java2d.StandardMediaLoader;

@VisibleForTesting
public class HeadlessMediaLoader
extends StandardMediaLoader {
    private boolean graphicsEnvironmentEnabled;

    public HeadlessMediaLoader(boolean graphicsEnvironmentEnabled) {
        this.graphicsEnvironmentEnabled = graphicsEnvironmentEnabled;
    }

    @Override
    public Image loadImage(FilePointer file) {
        if (this.graphicsEnvironmentEnabled) {
            return super.loadImage(file);
        }
        return new HeadlessImage();
    }

    @Override
    public OutlineFont loadFont(FilePointer file, FontStyle style) {
        if (this.graphicsEnvironmentEnabled) {
            return super.loadFont(file, style);
        }
        return new HeadlessFont(style);
    }
}

