/*
 * Decompiled with CFR 0.152.
 */
package nl.colorize.multimedialib.renderer.headless;

import com.google.common.annotations.VisibleForTesting;
import java.util.Collections;
import java.util.List;
import nl.colorize.multimedialib.math.Point2D;
import nl.colorize.multimedialib.math.Rect;
import nl.colorize.multimedialib.renderer.Canvas;
import nl.colorize.multimedialib.renderer.DisplayMode;
import nl.colorize.multimedialib.renderer.InputDevice;
import nl.colorize.multimedialib.renderer.KeyCode;
import nl.colorize.multimedialib.renderer.Renderer;
import nl.colorize.multimedialib.renderer.headless.HeadlessMediaLoader;
import nl.colorize.multimedialib.renderer.java2d.StandardNetworkAccess;
import nl.colorize.multimedialib.scene.ErrorHandler;
import nl.colorize.multimedialib.scene.Scene;
import nl.colorize.multimedialib.scene.SceneContext;

@VisibleForTesting
public class HeadlessRenderer
implements Renderer {
    private DisplayMode displayMode;
    private boolean graphicsEnvironmentEnabled;
    private SceneContext context;
    public static final int DEFAULT_WIDTH = 800;
    public static final int DEFAULT_HEIGHT = 600;
    public static final int DEFAULT_FRAMERATE = 30;

    public HeadlessRenderer(DisplayMode displayMode) {
        this.displayMode = displayMode;
        this.graphicsEnvironmentEnabled = true;
        HeadlessMediaLoader mediaLoader = new HeadlessMediaLoader(this.graphicsEnvironmentEnabled);
        StandardNetworkAccess network = new StandardNetworkAccess();
        NullInputDevice input = new NullInputDevice(displayMode.canvas());
        this.context = new SceneContext(displayMode, input, mediaLoader, network);
    }

    public HeadlessRenderer(Canvas canvas, int framerate) {
        this(new DisplayMode(canvas, framerate));
    }

    public HeadlessRenderer() {
        this(Canvas.flexible(800, 600), 30);
    }

    @Override
    public void start(Scene initialScene, ErrorHandler errorHandler) {
        this.context.changeScene(initialScene);
        this.doFrame();
    }

    public void doFrame() {
        this.context.update(1.0f / (float)this.displayMode.framerate());
    }

    @Override
    public DisplayMode getDisplayMode() {
        return this.displayMode;
    }

    @Override
    public String takeScreenshot() {
        throw new UnsupportedOperationException();
    }

    public void setGraphicsEnvironmentEnabled(boolean graphicsEnvironmentEnabled) {
        this.graphicsEnvironmentEnabled = graphicsEnvironmentEnabled;
    }

    public boolean isGraphicsEnvironmentEnabled() {
        return this.graphicsEnvironmentEnabled;
    }

    public SceneContext getContext() {
        return this.context;
    }

    private static class NullInputDevice
    implements InputDevice {
        private Canvas canvas;

        public NullInputDevice(Canvas canvas) {
            this.canvas = canvas;
        }

        @Override
        public List<Point2D> getPointers() {
            return Collections.emptyList();
        }

        @Override
        public boolean isPointerPressed(Rect area) {
            return false;
        }

        @Override
        public boolean isPointerReleased(Rect area) {
            return false;
        }

        @Override
        public boolean isTouchAvailable() {
            return false;
        }

        @Override
        public boolean isKeyboardAvailable() {
            return true;
        }

        @Override
        public boolean isKeyPressed(KeyCode keyCode) {
            return false;
        }

        @Override
        public boolean isKeyReleased(KeyCode keyCode) {
            return false;
        }

        @Override
        public String requestTextInput(String label, String initialValue) {
            return null;
        }

        @Override
        public Canvas getCanvas() {
            return this.canvas;
        }
    }
}

