/*
 * Decompiled with CFR 0.152.
 */
package nl.colorize.multimedialib.renderer.java2d;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.InputEvent;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import nl.colorize.multimedialib.math.Point2D;
import nl.colorize.multimedialib.math.Rect;
import nl.colorize.multimedialib.renderer.Canvas;
import nl.colorize.multimedialib.renderer.InputDevice;
import nl.colorize.multimedialib.renderer.KeyCode;
import nl.colorize.multimedialib.scene.Updatable;
import nl.colorize.util.swing.Popups;
import nl.colorize.util.swing.SwingUtils;

public class AWTInput
implements InputDevice,
Updatable,
KeyListener,
MouseListener,
MouseMotionListener {
    private Canvas canvas;
    private List<InputEvent> eventsBuffer;
    private int[] keyStates;
    private int mouseX;
    private int mouseY;
    private int mouseState;
    private static final int KEY_STATE_DEFAULT = 0;
    private static final int KEY_STATE_PRESSED = 1;
    private static final int KEY_STATE_RELEASED = 2;
    private static final int MOUSE_STATE_DEFAULT = 0;
    private static final int MOUSE_STATE_PRESSED = 1;
    private static final int MOUSE_STATE_RELEASED = 2;
    private static final int MAX_KEY_CODES = 600;
    private static final Map<KeyCode, Integer> KEY_CODE_MAPPING = new ImmutableMap.Builder().put((Object)KeyCode.LEFT, (Object)37).put((Object)KeyCode.RIGHT, (Object)39).put((Object)KeyCode.UP, (Object)38).put((Object)KeyCode.DOWN, (Object)40).put((Object)KeyCode.ENTER, (Object)10).put((Object)KeyCode.SPACEBAR, (Object)32).put((Object)KeyCode.ESCAPE, (Object)27).put((Object)KeyCode.SHIFT, (Object)16).put((Object)KeyCode.BACKSPACE, (Object)8).put((Object)KeyCode.TAB, (Object)9).put((Object)KeyCode.A, (Object)65).put((Object)KeyCode.B, (Object)66).put((Object)KeyCode.C, (Object)67).put((Object)KeyCode.D, (Object)68).put((Object)KeyCode.E, (Object)69).put((Object)KeyCode.F, (Object)70).put((Object)KeyCode.G, (Object)71).put((Object)KeyCode.H, (Object)72).put((Object)KeyCode.I, (Object)73).put((Object)KeyCode.J, (Object)74).put((Object)KeyCode.K, (Object)75).put((Object)KeyCode.L, (Object)76).put((Object)KeyCode.M, (Object)77).put((Object)KeyCode.N, (Object)78).put((Object)KeyCode.O, (Object)79).put((Object)KeyCode.P, (Object)80).put((Object)KeyCode.Q, (Object)81).put((Object)KeyCode.R, (Object)82).put((Object)KeyCode.S, (Object)83).put((Object)KeyCode.T, (Object)84).put((Object)KeyCode.U, (Object)85).put((Object)KeyCode.V, (Object)86).put((Object)KeyCode.W, (Object)87).put((Object)KeyCode.X, (Object)88).put((Object)KeyCode.Y, (Object)89).put((Object)KeyCode.Z, (Object)90).put((Object)KeyCode.N1, (Object)49).put((Object)KeyCode.N2, (Object)50).put((Object)KeyCode.N3, (Object)51).put((Object)KeyCode.N4, (Object)52).put((Object)KeyCode.N5, (Object)53).put((Object)KeyCode.N6, (Object)54).put((Object)KeyCode.N7, (Object)55).put((Object)KeyCode.N8, (Object)56).put((Object)KeyCode.N9, (Object)57).put((Object)KeyCode.N0, (Object)48).put((Object)KeyCode.F1, (Object)112).put((Object)KeyCode.F2, (Object)113).put((Object)KeyCode.F3, (Object)114).put((Object)KeyCode.F4, (Object)115).put((Object)KeyCode.F5, (Object)116).put((Object)KeyCode.F6, (Object)117).put((Object)KeyCode.F7, (Object)118).put((Object)KeyCode.F8, (Object)119).put((Object)KeyCode.F9, (Object)120).put((Object)KeyCode.F10, (Object)121).put((Object)KeyCode.F11, (Object)122).put((Object)KeyCode.F12, (Object)123).build();

    public AWTInput(Canvas canvas) {
        this.canvas = canvas;
        this.eventsBuffer = new CopyOnWriteArrayList<InputEvent>();
        this.keyStates = new int[600];
        this.mouseX = 0;
        this.mouseY = 0;
        this.mouseState = 0;
    }

    @Override
    public void update(float deltaTime) {
        InputEvent[] bufferSnapshot = this.eventsBuffer.toArray(new InputEvent[0]);
        this.eventsBuffer.clear();
        this.resetState();
        for (InputEvent event : bufferSnapshot) {
            if (event instanceof KeyEvent) {
                this.handleKeyEvent((KeyEvent)event);
                continue;
            }
            if (!(event instanceof MouseEvent)) continue;
            this.handleMouseEvent((MouseEvent)event);
        }
    }

    private void resetState() {
        for (int i = 0; i < 600; ++i) {
            if (this.keyStates[i] != 2) continue;
            this.keyStates[i] = 0;
        }
        if (this.mouseState == 2) {
            this.mouseState = 0;
        }
    }

    private void handleKeyEvent(KeyEvent event) {
        int eventID = event.getID();
        if (eventID == 401) {
            this.setKeyState(event.getKeyCode(), 1);
        } else if (eventID == 402) {
            this.setKeyState(event.getKeyCode(), 2);
        }
    }

    private void handleMouseEvent(MouseEvent event) {
        this.mouseX = event.getX();
        this.mouseY = event.getY();
        int eventID = event.getID();
        if (eventID == 501) {
            this.mouseState = 1;
        } else if (eventID == 502) {
            this.mouseState = 2;
        }
    }

    private void setKeyState(int keycode, int state) {
        if (keycode >= 0 && keycode < 600) {
            this.keyStates[keycode] = state;
        }
    }

    @Override
    public void keyPressed(KeyEvent e) {
        this.eventsBuffer.add(e);
        e.consume();
    }

    @Override
    public void keyReleased(KeyEvent e) {
        this.eventsBuffer.add(e);
        e.consume();
    }

    @Override
    public void keyTyped(KeyEvent e) {
        e.consume();
    }

    @Override
    public void mousePressed(MouseEvent e) {
        this.eventsBuffer.add(e);
        e.consume();
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        this.eventsBuffer.add(e);
        e.consume();
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        e.consume();
    }

    @Override
    public void mouseEntered(MouseEvent e) {
        e.consume();
    }

    @Override
    public void mouseExited(MouseEvent e) {
        e.consume();
    }

    @Override
    public void mouseMoved(MouseEvent e) {
        this.eventsBuffer.add(e);
        e.consume();
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        e.consume();
    }

    private Point2D getMousePosition() {
        float canvasX = this.canvas.toCanvasX(this.mouseX);
        float canvasY = this.canvas.toCanvasY(this.mouseY);
        return new Point2D(canvasX, canvasY);
    }

    @Override
    public List<Point2D> getPointers() {
        return ImmutableList.of((Object)this.getMousePosition());
    }

    @Override
    public boolean isPointerPressed(Rect area) {
        Point2D mousePosition = this.getMousePosition();
        return this.mouseState == 1 && area.contains(mousePosition);
    }

    @Override
    public boolean isPointerReleased(Rect area) {
        Point2D mousePosition = this.getMousePosition();
        return this.mouseState == 2 && area.contains(mousePosition);
    }

    @Override
    public boolean isTouchAvailable() {
        return false;
    }

    @Override
    public boolean isKeyboardAvailable() {
        return true;
    }

    @Override
    public boolean isKeyPressed(KeyCode keyCode) {
        return this.isKeyPressed(KEY_CODE_MAPPING.get((Object)keyCode));
    }

    public boolean isKeyPressed(int keycode) {
        return this.keyStates[keycode] == 1;
    }

    @Override
    public boolean isKeyReleased(KeyCode keyCode) {
        return this.isKeyReleased(KEY_CODE_MAPPING.get((Object)keyCode));
    }

    public boolean isKeyReleased(int keycode) {
        return this.keyStates[keycode] == 2;
    }

    @Override
    public String requestTextInput(String labelText, String initialValue) {
        JLabel label = new JLabel(labelText);
        JTextField field = new JTextField(initialValue);
        JPanel panel = new JPanel(new BorderLayout(0, 5));
        panel.add((Component)label, "North");
        panel.add((Component)field, "Center");
        SwingUtils.setPreferredWidth((JComponent)panel, (int)300);
        Popups.message(null, (String)"", (JComponent)panel);
        return field.getText();
    }

    @Override
    public Canvas getCanvas() {
        return this.canvas;
    }
}

