/*
 * Decompiled with CFR 0.152.
 */
package nl.colorize.multimedialib.renderer.java2d;

import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Insets;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.awt.image.BufferStrategy;
import java.awt.image.BufferedImage;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JFrame;
import nl.colorize.multimedialib.math.MathUtils;
import nl.colorize.multimedialib.renderer.Canvas;
import nl.colorize.multimedialib.renderer.DisplayMode;
import nl.colorize.multimedialib.renderer.Renderer;
import nl.colorize.multimedialib.renderer.WindowOptions;
import nl.colorize.multimedialib.renderer.java2d.AWTInput;
import nl.colorize.multimedialib.renderer.java2d.Java2DGraphicsContext;
import nl.colorize.multimedialib.renderer.java2d.StandardMediaLoader;
import nl.colorize.multimedialib.renderer.java2d.StandardNetworkAccess;
import nl.colorize.multimedialib.scene.ErrorHandler;
import nl.colorize.multimedialib.scene.Scene;
import nl.colorize.multimedialib.scene.SceneContext;
import nl.colorize.util.LogHelper;
import nl.colorize.util.Platform;
import nl.colorize.util.ResourceFile;
import nl.colorize.util.Stopwatch;
import nl.colorize.util.swing.ApplicationMenuListener;
import nl.colorize.util.swing.MacIntegration;
import nl.colorize.util.swing.SwingUtils;
import nl.colorize.util.swing.Utils2D;

public class Java2DRenderer
implements Renderer {
    private Canvas canvas;
    private int framerate;
    private Stopwatch syncTimer;
    private long oversleep;
    private SceneContext context;
    private StandardMediaLoader mediaLoader;
    private AWTInput inputDevice;
    private WindowOptions windowOptions;
    private JFrame window;
    private Java2DGraphicsContext graphicsContext;
    private AtomicBoolean canvasDirty;
    private AtomicBoolean terminated;
    private static final boolean ANTI_ALIASING = true;
    private static final boolean BILINEAR_SCALING = true;
    private static final long MIN_SLEEP_TIME = 1L;
    private static final long MAX_SLEEP_TIME = 50L;
    private static final Logger LOGGER = LogHelper.getLogger(Java2DRenderer.class);

    public Java2DRenderer(DisplayMode displayMode, WindowOptions windowOptions) {
        SwingUtils.initializeSwing();
        this.canvas = displayMode.canvas();
        this.framerate = displayMode.framerate();
        this.syncTimer = new Stopwatch();
        this.mediaLoader = new StandardMediaLoader();
        this.windowOptions = windowOptions;
        this.canvasDirty = new AtomicBoolean(true);
        this.terminated = new AtomicBoolean(false);
    }

    @Override
    public void start(Scene initialScene, ErrorHandler errorHandler) {
        this.window = this.initializeWindow(this.windowOptions);
        this.graphicsContext = new Java2DGraphicsContext(this.canvas, this.mediaLoader);
        StandardNetworkAccess network = new StandardNetworkAccess();
        this.context = new SceneContext(this.getDisplayMode(), this.inputDevice, this.mediaLoader, network);
        this.context.changeScene(initialScene);
        Runnable animationLoop = () -> this.runAnimationLoop(errorHandler);
        Thread renderingThread = new Thread(animationLoop, "MultimediaLib-RenderingThread");
        renderingThread.start();
    }

    private JFrame initializeWindow(WindowOptions windowOptions) {
        this.window = new JFrame();
        this.window.setDefaultCloseOperation(2);
        this.window.setResizable(true);
        this.window.setIgnoreRepaint(true);
        this.window.setFocusTraversalKeysEnabled(false);
        this.window.addWindowListener(this.createWindowCloseListener());
        this.window.addComponentListener(this.createResizeListener());
        this.window.setTitle(windowOptions.title());
        this.window.setIconImage(this.loadIcon(windowOptions));
        this.window.getContentPane().setPreferredSize(new Dimension(this.canvas.getWidth(), this.canvas.getHeight()));
        this.window.pack();
        this.window.setLocationRelativeTo(null);
        this.window.setVisible(true);
        this.window.createBufferStrategy(2);
        this.inputDevice = new AWTInput(this.canvas);
        this.window.addKeyListener(this.inputDevice);
        this.window.addMouseListener(this.inputDevice);
        this.window.addMouseMotionListener(this.inputDevice);
        if (Platform.isMac()) {
            MacIntegration.setApplicationMenuListener((ApplicationMenuListener)windowOptions.appMenuListener());
        }
        if (windowOptions.fullscreen()) {
            SwingUtils.goFullScreen((JFrame)this.window);
        }
        return this.window;
    }

    private ComponentListener createResizeListener() {
        return new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                Java2DRenderer.this.canvasDirty.set(true);
            }
        };
    }

    private WindowListener createWindowCloseListener() {
        return new WindowAdapter(){

            @Override
            public void windowClosed(WindowEvent e) {
                LOGGER.info("Closing window");
                Java2DRenderer.this.terminated.set(true);
                if (!Java2DRenderer.this.windowOptions.embedded()) {
                    System.exit(0);
                }
            }
        };
    }

    private Image loadIcon(WindowOptions windowOptions) {
        if (windowOptions.iconFile() != null) {
            ResourceFile iconFile = new ResourceFile(windowOptions.iconFile().getPath());
            return SwingUtils.loadIcon((ResourceFile)iconFile).getImage();
        }
        return null;
    }

    private void runAnimationLoop(ErrorHandler errorHandler) {
        while (!this.terminated.get()) {
            try {
                this.syncTimer.tick();
                if (this.canvasDirty.get()) {
                    this.canvasDirty.set(false);
                    this.prepareCanvas();
                }
                this.context.getFrameStats().markFrameStart();
                float frameTime = 1.0f / (float)this.framerate;
                this.inputDevice.update(frameTime);
                this.context.update(frameTime);
                this.context.getFrameStats().markFrameUpdate();
                this.drawFrame();
                this.context.getFrameStats().markFrameRender();
                Thread.yield();
                long elapsedTime = this.syncTimer.tock();
                this.syncFrame(elapsedTime);
            }
            catch (Exception e) {
                LOGGER.log(Level.SEVERE, "Error during animation loop", e);
                errorHandler.onError(this.context, e);
                this.quit();
            }
        }
    }

    private void drawFrame() {
        BufferStrategy windowBuffer = this.prepareWindowBuffer();
        Graphics bufferGraphics = this.accessWindowGraphics(windowBuffer);
        if (bufferGraphics != null) {
            Graphics2D g2 = Utils2D.createGraphics((Graphics)bufferGraphics, (boolean)true, (boolean)true);
            this.drawFrame(g2);
            this.blitGraphicsContext(windowBuffer);
            this.graphicsContext.dispose();
        }
    }

    private Graphics accessWindowGraphics(BufferStrategy windowBuffer) {
        try {
            return windowBuffer.getDrawGraphics();
        }
        catch (IllegalStateException e) {
            LOGGER.warning("Window buffer graphics not available: " + e.getMessage());
            return null;
        }
    }

    private void drawFrame(Graphics2D g2) {
        this.graphicsContext.bind(g2);
        this.graphicsContext.clear(this.window.getWidth(), this.window.getHeight() + 50);
        this.context.getStage().visit(this.graphicsContext);
    }

    private void prepareCanvas() {
        Insets windowInsets = this.window.getInsets();
        int windowWidth = this.window.getWidth() - windowInsets.left - windowInsets.right;
        int windowHeight = this.window.getHeight() - windowInsets.top - windowInsets.bottom;
        this.canvas.resizeScreen(windowWidth, windowHeight);
        this.canvas.offsetScreen(windowInsets.left, windowInsets.top);
    }

    private void syncFrame(long currentTrameTime) {
        long targetFrameTime = 1000L / (long)this.framerate;
        long sleepTime = targetFrameTime - currentTrameTime - this.oversleep;
        sleepTime = MathUtils.clamp(sleepTime, 1L, 50L);
        try {
            Stopwatch sleepTimer = new Stopwatch();
            Thread.sleep(sleepTime);
            long actualSleepTime = sleepTimer.tock();
            this.oversleep = actualSleepTime - sleepTime;
        }
        catch (InterruptedException e) {
            LOGGER.warning("Frame sync interrupted");
        }
    }

    private BufferStrategy prepareWindowBuffer() {
        return this.window.getBufferStrategy();
    }

    private void blitGraphicsContext(BufferStrategy windowBuffer) {
        if (!windowBuffer.contentsLost()) {
            windowBuffer.show();
            if (Platform.isLinux()) {
                this.window.getToolkit().sync();
            }
        }
    }

    @Override
    public DisplayMode getDisplayMode() {
        return new DisplayMode(this.canvas, this.framerate);
    }

    @Override
    public String takeScreenshot() {
        BufferedImage screenshot = new BufferedImage(this.canvas.getWidth(), this.canvas.getHeight(), 2);
        Graphics2D g2 = Utils2D.createGraphics((BufferedImage)screenshot, (boolean)true, (boolean)true);
        this.window.getContentPane().print(g2);
        g2.dispose();
        return Utils2D.toDataURL((BufferedImage)screenshot);
    }

    public void quit() {
        this.terminated.set(true);
        if (this.window != null) {
            this.window.dispose();
        }
    }
}

