/*
 * Decompiled with CFR 0.152.
 */
package nl.colorize.multimedialib.renderer.java2d;

import com.google.common.base.Charsets;
import com.google.common.reflect.ClassPath;
import java.awt.Font;
import java.awt.FontFormatException;
import java.awt.GraphicsEnvironment;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.Collections;
import java.util.Properties;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import nl.colorize.multimedialib.graphics.FontStyle;
import nl.colorize.multimedialib.graphics.Image;
import nl.colorize.multimedialib.graphics.OutlineFont;
import nl.colorize.multimedialib.graphics.PolygonModel;
import nl.colorize.multimedialib.renderer.Audio;
import nl.colorize.multimedialib.renderer.FilePointer;
import nl.colorize.multimedialib.renderer.MediaException;
import nl.colorize.multimedialib.renderer.MediaLoader;
import nl.colorize.multimedialib.renderer.UnsupportedGraphicsModeException;
import nl.colorize.multimedialib.renderer.java2d.AWTFont;
import nl.colorize.multimedialib.renderer.java2d.AWTImage;
import nl.colorize.multimedialib.renderer.java2d.MP3;
import nl.colorize.util.Configuration;
import nl.colorize.util.LoadUtils;
import nl.colorize.util.LogHelper;
import nl.colorize.util.Platform;
import nl.colorize.util.ResourceFile;
import nl.colorize.util.swing.Utils2D;

public class StandardMediaLoader
implements MediaLoader {
    private Set<String> classPathResources = Collections.emptySet();
    private static final Logger LOGGER = LogHelper.getLogger(StandardMediaLoader.class);

    public StandardMediaLoader() {
        try {
            ClassLoader classLoader = StandardMediaLoader.class.getClassLoader();
            this.classPathResources = ClassPath.from((ClassLoader)classLoader).getResources().stream().map(resource -> resource.getResourceName()).collect(Collectors.toSet());
        }
        catch (IOException e) {
            LOGGER.log(Level.WARNING, "Failed to preload classpath resources", e);
        }
    }

    @Override
    public Image loadImage(FilePointer file) {
        try {
            ResourceFile source = new ResourceFile(file.getPath());
            BufferedImage loadedImage = Utils2D.loadImage((InputStream)source.openStream());
            return new AWTImage(loadedImage, file);
        }
        catch (IOException e) {
            throw new MediaException("Cannot load image from " + file.getPath(), e);
        }
    }

    @Override
    public Audio loadAudio(FilePointer file) {
        return new MP3(new ResourceFile(file.getPath()));
    }

    @Override
    public OutlineFont loadFont(FilePointer file, FontStyle style) {
        OutlineFont outlineFont;
        block8: {
            ResourceFile source = new ResourceFile(file.getPath());
            InputStream stream = source.openStream();
            try {
                Font font = Font.createFont(0, stream);
                GraphicsEnvironment env = GraphicsEnvironment.getLocalGraphicsEnvironment();
                env.registerFont(font);
                outlineFont = new AWTFont(font, style).derive(style);
                if (stream == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (stream != null) {
                        try {
                            stream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (FontFormatException | IOException e) {
                    throw new MediaException("Cannot load font from " + file.getPath(), e);
                }
            }
            stream.close();
        }
        return outlineFont;
    }

    @Override
    public String loadText(FilePointer file) {
        ResourceFile resourceFile = new ResourceFile(file.getPath());
        return resourceFile.read(Charsets.UTF_8);
    }

    @Override
    public PolygonModel loadModel(FilePointer file) {
        throw new UnsupportedGraphicsModeException();
    }

    @Override
    public boolean containsResourceFile(FilePointer file) {
        if (this.classPathResources.isEmpty()) {
            return new ResourceFile(file.getPath()).exists();
        }
        return this.classPathResources.contains(file.getPath());
    }

    @Override
    public Configuration loadApplicationData(String appName, String fileName) {
        File file = Platform.getApplicationData((String)appName, (String)fileName);
        if (!file.exists()) {
            return Configuration.fromProperties();
        }
        try {
            Properties properties = LoadUtils.loadProperties((File)file, (Charset)Charsets.UTF_8);
            return Configuration.fromProperties((Properties)properties);
        }
        catch (IOException e) {
            throw new MediaException("Unable to load application data", e);
        }
    }

    @Override
    public void saveApplicationData(Configuration data, String appName, String fileName) {
        try {
            File file = Platform.getApplicationData((String)appName, (String)fileName);
            Files.writeString(file.toPath(), (CharSequence)data.serialize(), Charsets.UTF_8, new OpenOption[0]);
        }
        catch (IOException e) {
            throw new MediaException("Unable to save application data", e);
        }
    }
}

