/*
 * Decompiled with CFR 0.152.
 */
package nl.colorize.multimedialib.renderer.java2d;

import com.google.common.base.Charsets;
import java.io.IOException;
import java.net.URI;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.UUID;
import java.util.logging.Level;
import java.util.logging.Logger;
import nl.colorize.multimedialib.renderer.NetworkAccess;
import nl.colorize.multimedialib.renderer.NetworkConnection;
import nl.colorize.util.Callback;
import nl.colorize.util.LogHelper;
import nl.colorize.util.http.Headers;
import nl.colorize.util.http.Method;
import nl.colorize.util.http.PostData;
import nl.colorize.util.http.URLLoader;
import nl.colorize.util.http.URLResponse;
import org.java_websocket.client.WebSocketClient;
import org.java_websocket.handshake.ServerHandshake;

public class StandardNetworkAccess
implements NetworkAccess {
    private static final Logger LOGGER = LogHelper.getLogger(StandardNetworkAccess.class);

    @Override
    public void get(String url, Headers headers, Callback<String> callback) {
        URLLoader request = this.createRequest(Method.GET, url, headers, null);
        this.send(request, callback);
    }

    @Override
    public void post(String url, Headers headers, PostData body, Callback<String> callback) {
        URLLoader request = this.createRequest(Method.POST, url, headers, body);
        this.send(request, callback);
    }

    private URLLoader createRequest(Method method, String url, Headers headers, PostData body) {
        URLLoader request = URLLoader.create((Method)method, (String)url, (Charset)StandardCharsets.UTF_8);
        request.addHeader("X-Requested-With", "MultimediaLib");
        if (headers != null) {
            request.addHeaders(headers);
        }
        if (body != null) {
            request.setBody(body);
        }
        return request;
    }

    private void send(URLLoader request, Callback<String> callback) {
        Runnable task = () -> {
            try {
                URLResponse response = request.sendRequest();
                callback.onResponse((Object)response.getBody());
            }
            catch (IOException e) {
                callback.onError((Throwable)e);
            }
        };
        Thread backgroundThread = new Thread(task, "MultimediaLib-StandardNetworkAccess");
        backgroundThread.start();
    }

    @Override
    public NetworkConnection connectWebSocket(String uri) {
        JavaWebSocketClient client = new JavaWebSocketClient(URI.create(uri));
        client.connect();
        return client.connection;
    }

    @Override
    public NetworkConnection connectWebRTC(String id) {
        throw new UnsupportedOperationException("WebRTC not supported");
    }

    private static class JavaWebSocketClient
    extends WebSocketClient {
        private NetworkConnection connection = new NetworkConnection(arg_0 -> ((JavaWebSocketClient)this).send(arg_0));

        public JavaWebSocketClient(URI uri) {
            super(uri);
        }

        public void onOpen(ServerHandshake handshake) {
            LOGGER.info("Web socket connection: " + handshake.getHttpStatusMessage());
            this.connection.receiveID(UUID.randomUUID().toString());
            this.connection.connect();
            this.send("__init");
        }

        public void onClose(int code, String reason, boolean remote) {
            LOGGER.info("Web socket connection closed");
            this.connection.disconnect();
        }

        public void onMessage(String message) {
            this.connection.queueReceivedMessage(message);
        }

        public void onMessage(ByteBuffer buffer) {
            String message = new String(buffer.array(), Charsets.UTF_8);
            this.connection.queueReceivedMessage(message);
        }

        public void onError(Exception e) {
            LOGGER.log(Level.WARNING, "Web socket error", e);
        }
    }
}

