/*
 * Decompiled with CFR 0.152.
 */
package nl.colorize.multimedialib.renderer.libgdx;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.Pixmap;
import com.badlogic.gdx.graphics.Texture;
import com.badlogic.gdx.graphics.TextureData;
import com.badlogic.gdx.graphics.g2d.Batch;
import com.badlogic.gdx.graphics.g2d.SpriteBatch;
import com.badlogic.gdx.graphics.g2d.TextureRegion;
import com.badlogic.gdx.graphics.glutils.ShapeRenderer;
import com.google.common.base.Preconditions;
import java.util.HashMap;
import java.util.Map;
import nl.colorize.multimedialib.graphics.Align;
import nl.colorize.multimedialib.graphics.ColorRGB;
import nl.colorize.multimedialib.graphics.Primitive;
import nl.colorize.multimedialib.graphics.Sprite;
import nl.colorize.multimedialib.graphics.Text;
import nl.colorize.multimedialib.graphics.Transform;
import nl.colorize.multimedialib.math.Circle;
import nl.colorize.multimedialib.math.Line;
import nl.colorize.multimedialib.math.Point2D;
import nl.colorize.multimedialib.math.Polygon;
import nl.colorize.multimedialib.math.Rect;
import nl.colorize.multimedialib.renderer.Canvas;
import nl.colorize.multimedialib.renderer.libgdx.GDXBitmapFont;
import nl.colorize.multimedialib.renderer.libgdx.GDXImage;
import nl.colorize.multimedialib.scene.StageVisitor;

public class GDXGraphics2D
implements StageVisitor {
    private Canvas canvas;
    private SpriteBatch spriteBatch;
    private ShapeRenderer shapeBatch;
    private Map<TextureRegion, TextureRegion> maskCache;
    private static final Transform DEFAULT_TRANSFORM = new Transform();
    private static final int CIRCLE_SEGMENTS = 32;

    protected GDXGraphics2D(Canvas canvas) {
        this.canvas = canvas;
        this.spriteBatch = new SpriteBatch();
        this.shapeBatch = new ShapeRenderer();
        this.maskCache = new HashMap<TextureRegion, TextureRegion>();
    }

    @Override
    public void drawBackground(ColorRGB backgroundColor) {
        this.switchMode(false, true);
        this.shapeBatch.setColor(this.convertColor(backgroundColor, 100.0f));
        this.shapeBatch.rect(this.toScreenX(0.0f), this.toScreenY(0.0f), this.toScreenX(this.canvas.getWidth()), this.toScreenY(this.canvas.getHeight()));
    }

    @Override
    public void drawLine(Primitive graphic, Line line) {
        float x0 = this.toScreenX(line.getStart().getX());
        float y0 = this.toScreenY(line.getStart().getY());
        float x1 = this.toScreenX(line.getEnd().getX());
        float y1 = this.toScreenY(line.getEnd().getY());
        this.switchMode(false, true);
        this.shapeBatch.setColor(this.convertColor(graphic.getColor()));
        this.shapeBatch.line(x0, y0, x1, y1);
    }

    @Override
    public void drawRect(Primitive graphic, Rect rect) {
        float x = this.toScreenX(rect.getX());
        float y = this.toScreenY(rect.getEndY());
        float width = rect.getWidth() * this.canvas.getZoomLevel();
        float height = rect.getHeight() * this.canvas.getZoomLevel();
        this.switchMode(false, true);
        this.shapeBatch.setColor(this.convertColor(graphic.getColor(), graphic.getAlpha()));
        this.shapeBatch.rect(x, y, width, height);
    }

    @Override
    public void drawCircle(Primitive graphic, Circle circle) {
        float x = this.toScreenX(circle.getCenterX());
        float y = this.toScreenY(circle.getCenterY());
        float radius = circle.getRadius() * this.canvas.getZoomLevel();
        this.switchMode(false, true);
        this.shapeBatch.setColor(this.convertColor(graphic.getColor(), graphic.getAlpha()));
        this.shapeBatch.circle(x, y, radius, 32);
    }

    @Override
    public void drawPolygon(Primitive graphic, Polygon polygon) {
        if (polygon.getNumPoints() == 3) {
            this.drawTriangle(polygon.getVertices(), graphic.getColor(), graphic.getAlpha());
        } else {
            for (Polygon triangle : polygon.subdivide()) {
                this.drawTriangle(triangle.getVertices(), graphic.getColor(), graphic.getAlpha());
            }
        }
    }

    private void drawTriangle(float[] vertices, ColorRGB color, float alpha) {
        this.switchMode(false, true);
        this.shapeBatch.setColor(this.convertColor(color, alpha));
        this.shapeBatch.triangle(this.toScreenX(vertices[0]), this.toScreenY(vertices[1]), this.toScreenX(vertices[2]), this.toScreenY(vertices[3]), this.toScreenX(vertices[4]), this.toScreenY(vertices[5]));
    }

    @Override
    public void drawSprite(Sprite sprite) {
        TextureRegion textureRegion = ((GDXImage)sprite.getCurrentGraphics()).getTextureRegion();
        Transform transform = sprite.getTransform();
        if (transform == null) {
            transform = DEFAULT_TRANSFORM;
        }
        this.drawSprite(textureRegion, sprite.getPosition(), transform);
    }

    private void drawSprite(TextureRegion textureRegion, Point2D position, Transform transform) {
        float screenX = this.toScreenX(position.getX());
        float screenY = this.toScreenY(position.getY());
        float screenWidth = (float)textureRegion.getRegionWidth() * this.canvas.getZoomLevel();
        float screenHeight = (float)textureRegion.getRegionHeight() * this.canvas.getZoomLevel();
        if (transform.getMask() != null) {
            textureRegion = this.getMask(textureRegion, transform.getMask());
        }
        this.switchMode(true, false);
        this.spriteBatch.setColor(1.0f, 1.0f, 1.0f, transform.getAlpha() / 100.0f);
        this.spriteBatch.draw(textureRegion, screenX - screenWidth / 2.0f, screenY - screenHeight / 2.0f, screenWidth / 2.0f, screenHeight / 2.0f, screenWidth, screenHeight, transform.getScaleX() / 100.0f, transform.getScaleY() / 100.0f, -transform.getRotation());
    }

    private TextureRegion getMask(TextureRegion textureRegion, ColorRGB color) {
        TextureRegion mask = this.maskCache.get(textureRegion);
        if (mask == null) {
            mask = this.createMask(textureRegion, color);
            this.maskCache.put(textureRegion, mask);
        }
        return mask;
    }

    private TextureRegion createMask(TextureRegion original, ColorRGB color) {
        TextureData textureData = original.getTexture().getTextureData();
        textureData.prepare();
        Pixmap pixels = textureData.consumePixmap();
        Pixmap mask = new Pixmap(original.getRegionWidth(), original.getRegionHeight(), Pixmap.Format.RGBA8888);
        for (int x = 0; x < original.getRegionWidth(); ++x) {
            for (int y = 0; y < original.getRegionHeight(); ++y) {
                int rgba = pixels.getPixel(original.getRegionX() + x, original.getRegionY() + y);
                int maskRGBA = Color.rgba8888((Color)this.convertColor(color, new Color((int)rgba).a * 100.0f));
                mask.drawPixel(x, y, maskRGBA);
            }
        }
        Texture texture = new Texture(mask);
        pixels.dispose();
        mask.dispose();
        return new TextureRegion(texture);
    }

    @Override
    public void drawText(Text text) {
        GDXBitmapFont baseFont = (GDXBitmapFont)text.getFont();
        GDXBitmapFont displayFont = (GDXBitmapFont)baseFont.scale(this.canvas);
        float screenX = this.toScreenX(text.getPosition().getX());
        int align = this.getTextAlign(text.getAlign());
        this.switchMode(true, false);
        text.forLines((i, line) -> {
            float lineY = text.getPosition().getY() + (float)i.intValue() * text.getLineHeight(this.canvas);
            float screenY = this.toScreenY(lineY - 0.4f * (float)displayFont.getStyle().size());
            displayFont.getBitmapFont().draw((Batch)this.spriteBatch, (CharSequence)line, screenX, screenY, 0.0f, align, false);
        });
    }

    private int getTextAlign(Align align) {
        switch (align) {
            case LEFT: {
                return 8;
            }
            case CENTER: {
                return 1;
            }
            case RIGHT: {
                return 16;
            }
        }
        throw new AssertionError();
    }

    private float toScreenX(float x) {
        return this.canvas.toScreenX(x);
    }

    public float toScreenY(float y) {
        return (float)Gdx.graphics.getHeight() - this.canvas.toScreenY(y);
    }

    private Color convertColor(ColorRGB color, float alpha) {
        return new Color((float)color.getR() / 255.0f, (float)color.getG() / 255.0f, (float)color.getB() / 255.0f, alpha / 100.0f);
    }

    private Color convertColor(ColorRGB color) {
        return this.convertColor(color, 100.0f);
    }

    protected void switchMode(boolean sprites, boolean shapes) {
        Preconditions.checkArgument((!sprites || !shapes ? 1 : 0) != 0, (Object)"Invalid drawing mode");
        if (sprites) {
            this.endShapeBatch();
            this.beginSpriteBatch();
        } else if (shapes) {
            this.endSpriteBatch();
            this.beginShapeBatch();
        } else {
            this.endSpriteBatch();
            this.endShapeBatch();
        }
    }

    private void beginSpriteBatch() {
        if (!this.spriteBatch.isDrawing()) {
            this.spriteBatch.begin();
        }
    }

    private void endSpriteBatch() {
        if (this.spriteBatch.isDrawing()) {
            this.spriteBatch.end();
        }
    }

    private void beginShapeBatch() {
        if (!this.shapeBatch.isDrawing()) {
            Gdx.gl.glEnable(3042);
            this.shapeBatch.begin(ShapeRenderer.ShapeType.Filled);
        }
    }

    private void endShapeBatch() {
        if (this.shapeBatch.isDrawing()) {
            this.shapeBatch.end();
        }
    }

    protected void dispose() {
        this.endSpriteBatch();
        this.endShapeBatch();
        this.spriteBatch.dispose();
        this.shapeBatch.dispose();
    }
}

