/*
 * Decompiled with CFR 0.152.
 */
package nl.colorize.multimedialib.renderer.libgdx;

import com.badlogic.gdx.graphics.g3d.ModelInstance;
import com.badlogic.gdx.graphics.g3d.model.Animation;
import com.badlogic.gdx.graphics.g3d.utils.AnimationController;
import java.util.HashMap;
import java.util.Map;
import nl.colorize.multimedialib.graphics.AnimationInfo;
import nl.colorize.multimedialib.graphics.PolygonModel;
import nl.colorize.multimedialib.graphics.Transform3D;

public class GDXModel
implements PolygonModel {
    private ModelInstance instance;
    private Transform3D transform;
    private Map<String, AnimationInfo> animations;
    private AnimationController animationController;

    protected GDXModel(ModelInstance instance) {
        this.instance = instance;
        this.transform = new Transform3D();
        this.animations = new HashMap<String, AnimationInfo>();
        for (Animation anim : instance.model.animations) {
            this.animations.put(anim.id, new GDXModelAnimation(anim));
        }
    }

    protected ModelInstance getInstance() {
        return this.instance;
    }

    @Override
    public void update(float deltaTime) {
        this.instance.transform.setToTranslation(this.transform.getPosition().getX(), this.transform.getPosition().getY(), this.transform.getPosition().getZ());
        this.instance.transform.rotate(1.0f, 0.0f, 0.0f, this.transform.getRotationX());
        this.instance.transform.rotate(0.0f, 1.0f, 0.0f, this.transform.getRotationY());
        this.instance.transform.rotate(0.0f, 0.0f, 1.0f, this.transform.getRotationZ());
        this.instance.transform.scale(this.transform.getScaleX(), this.transform.getScaleY(), this.transform.getScaleZ());
        if (this.animationController != null) {
            this.animationController.update(deltaTime);
            if (this.isAnimationCompleted()) {
                this.animationController = null;
            }
        }
    }

    @Override
    public Map<String, AnimationInfo> getAnimations() {
        return this.animations;
    }

    @Override
    public void playAnimation(String animation, boolean loop) {
        int loopCount = loop ? Integer.MAX_VALUE : 1;
        this.animationController = new AnimationController(this.instance);
        this.animationController.animate(animation, loopCount, 1.0f, null, 0.0f);
    }

    private boolean isAnimationCompleted() {
        return this.animationController == null || this.animationController.current == null || this.animationController.current.loopCount == 0;
    }

    @Override
    public Transform3D getTransform() {
        return this.transform;
    }

    @Override
    public PolygonModel copy() {
        ModelInstance instanceCopy = new ModelInstance(this.instance.model);
        return new GDXModel(instanceCopy);
    }

    private static class GDXModelAnimation
    implements AnimationInfo {
        private Animation animation;

        public GDXModelAnimation(Animation animation) {
            this.animation = animation;
        }

        @Override
        public float getDuration() {
            return this.animation.duration;
        }

        @Override
        public boolean isLoop() {
            return false;
        }
    }
}

