/*
 * Decompiled with CFR 0.152.
 */
package nl.colorize.multimedialib.renderer.libgdx;

import com.badlogic.gdx.ApplicationListener;
import com.badlogic.gdx.Files;
import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.backends.lwjgl3.Lwjgl3Application;
import com.badlogic.gdx.backends.lwjgl3.Lwjgl3ApplicationConfiguration;
import com.badlogic.gdx.files.FileHandle;
import com.badlogic.gdx.graphics.Camera;
import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.PerspectiveCamera;
import com.badlogic.gdx.graphics.Pixmap;
import com.badlogic.gdx.graphics.PixmapIO;
import com.badlogic.gdx.graphics.g3d.Attribute;
import com.badlogic.gdx.graphics.g3d.Environment;
import com.badlogic.gdx.graphics.g3d.ModelBatch;
import com.badlogic.gdx.graphics.g3d.ModelInstance;
import com.badlogic.gdx.graphics.g3d.attributes.ColorAttribute;
import com.badlogic.gdx.graphics.g3d.environment.DirectionalLight;
import com.badlogic.gdx.graphics.glutils.HdpiMode;
import com.badlogic.gdx.math.Vector3;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import nl.colorize.multimedialib.graphics.ColorRGB;
import nl.colorize.multimedialib.graphics.PolygonModel;
import nl.colorize.multimedialib.math.Point3D;
import nl.colorize.multimedialib.renderer.Canvas;
import nl.colorize.multimedialib.renderer.DisplayMode;
import nl.colorize.multimedialib.renderer.MediaException;
import nl.colorize.multimedialib.renderer.Renderer;
import nl.colorize.multimedialib.renderer.WindowOptions;
import nl.colorize.multimedialib.renderer.java2d.StandardNetworkAccess;
import nl.colorize.multimedialib.renderer.libgdx.GDXGraphics2D;
import nl.colorize.multimedialib.renderer.libgdx.GDXInput;
import nl.colorize.multimedialib.renderer.libgdx.GDXMediaLoader;
import nl.colorize.multimedialib.renderer.libgdx.GDXModel;
import nl.colorize.multimedialib.scene.ErrorHandler;
import nl.colorize.multimedialib.scene.Scene;
import nl.colorize.multimedialib.scene.SceneContext;
import nl.colorize.multimedialib.scene.Stage;
import nl.colorize.multimedialib.scene.Stage3D;
import nl.colorize.util.LoadUtils;
import nl.colorize.util.LogHelper;
import nl.colorize.util.swing.Utils2D;

public class GDXRenderer
implements Renderer,
ApplicationListener {
    private Canvas canvas;
    private int framerate;
    private WindowOptions window;
    private GDXInput input;
    private GDXMediaLoader mediaLoader;
    private SceneContext context;
    private Scene initialScene;
    private PerspectiveCamera camera;
    private DirectionalLight light;
    private Environment environment;
    private ModelBatch modelBatch;
    private List<ModelInstance> displayList;
    private GDXGraphics2D graphicsContext;
    private static final int FIELD_OF_VIEW = 75;
    private static final float NEAR_PLANE = 1.0f;
    private static final float FAR_PLANE = 300.0f;
    private static final Logger LOGGER = LogHelper.getLogger(GDXRenderer.class);

    public GDXRenderer(DisplayMode displayMode, WindowOptions window) {
        this.canvas = displayMode.canvas();
        this.framerate = displayMode.framerate();
        this.window = window;
    }

    @Override
    public void start(Scene initialScene, ErrorHandler errorHandler) {
        this.initialScene = initialScene;
        Lwjgl3ApplicationConfiguration config = new Lwjgl3ApplicationConfiguration();
        config.setWindowedMode(this.canvas.getWidth(), this.canvas.getHeight());
        config.setDecorated(true);
        config.setIdleFPS(this.framerate);
        config.setForegroundFPS(this.framerate);
        config.setHdpiMode(HdpiMode.Pixels);
        config.setTitle(this.window.title());
        if (this.window.iconFile() != null) {
            config.setWindowIcon(Files.FileType.Internal, new String[]{this.window.iconFile().getPath()});
        }
        try {
            new Lwjgl3Application((ApplicationListener)this, config);
        }
        catch (Exception e) {
            LOGGER.log(Level.SEVERE, "Error during animation loop", e);
        }
    }

    public void create() {
        this.mediaLoader = new GDXMediaLoader();
        this.input = new GDXInput(this.canvas);
        StandardNetworkAccess network = new StandardNetworkAccess();
        this.context = new SceneContext(this.getDisplayMode(), this.input, this.mediaLoader, network);
        this.context.changeScene(this.initialScene);
        this.resize(this.canvas.getWidth(), this.canvas.getHeight());
        this.modelBatch = new ModelBatch();
        this.displayList = new ArrayList<ModelInstance>();
        this.graphicsContext = new GDXGraphics2D(this.canvas);
        this.initStage();
    }

    private void initStage() {
        this.camera = new PerspectiveCamera(75.0f, (float)Gdx.graphics.getWidth(), (float)Gdx.graphics.getHeight());
        this.camera.near = 1.0f;
        this.camera.far = 300.0f;
        this.camera.update();
        this.light = new DirectionalLight();
        this.environment = new Environment();
        this.environment.add(this.light);
    }

    public void dispose() {
        this.modelBatch.dispose();
        this.graphicsContext.dispose();
        this.mediaLoader.dispose();
    }

    public void resize(int width, int height) {
        this.canvas.resizeScreen(width, height);
    }

    public void pause() {
    }

    public void resume() {
    }

    public void render() {
        this.context.getFrameStats().markFrameStart();
        Gdx.gl.glViewport(0, 0, Gdx.graphics.getWidth(), Gdx.graphics.getHeight());
        Gdx.gl.glClearColor(0.0f, 0.0f, 0.0f, 1.0f);
        Gdx.gl.glClear(16640);
        float frameTime = 1.0f / (float)this.framerate;
        this.input.update(frameTime);
        this.context.update(frameTime);
        this.context.getFrameStats().markFrameUpdate();
        this.renderStage(this.context.getStage());
        this.graphicsContext.switchMode(false, false);
        this.context.getFrameStats().markFrameRender();
    }

    private void renderStage(Stage stage) {
        if (stage instanceof Stage3D) {
            Stage3D stage3D = (Stage3D)stage;
            this.camera.position.set(this.toVector(stage3D.getCameraPosition()));
            this.camera.up.set(0.0f, 1.0f, 0.0f);
            this.camera.lookAt(this.toVector(stage3D.getCameraTarget()));
            this.camera.update();
            this.environment.set((Attribute)new ColorAttribute(ColorAttribute.AmbientLight, this.toColor(stage3D.getAmbientLight())));
            this.light.set(this.toColor(stage3D.getLightColor()), this.toVector(stage3D.getLightPosition()));
        }
        this.updateDisplayList();
        this.modelBatch.begin((Camera)this.camera);
        this.modelBatch.render(this.displayList, this.environment);
        this.modelBatch.end();
        stage.visit(this.graphicsContext);
    }

    private void updateDisplayList() {
        this.displayList.clear();
        Stage stage = this.context.getStage();
        if (stage instanceof Stage3D) {
            Stage3D stage3D = (Stage3D)stage;
            for (PolygonModel model : stage3D.getModels()) {
                GDXModel gdxModel = (GDXModel)model;
                this.displayList.add(gdxModel.getInstance());
            }
        }
    }

    private Vector3 toVector(Point3D point) {
        return new Vector3(point.getX(), point.getY(), point.getZ());
    }

    private Color toColor(ColorRGB color) {
        return this.mediaLoader.toColor(color);
    }

    @Override
    public DisplayMode getDisplayMode() {
        return new DisplayMode(this.canvas, this.framerate);
    }

    @Override
    public String takeScreenshot() {
        Pixmap screenshot = Pixmap.createFromFrameBuffer((int)0, (int)0, (int)Gdx.graphics.getWidth(), (int)Gdx.graphics.getHeight());
        File tempFile = LoadUtils.getTempFile((String)".png");
        PixmapIO.writePNG((FileHandle)Gdx.files.external(tempFile.getAbsolutePath()), (Pixmap)screenshot, (int)-1, (boolean)true);
        screenshot.dispose();
        try {
            BufferedImage screenshotImage = Utils2D.loadImage((File)tempFile);
            return Utils2D.toDataURL((BufferedImage)screenshotImage);
        }
        catch (IOException e) {
            throw new MediaException("Screenshot failed", e);
        }
    }
}

