/*
 * Decompiled with CFR 0.152.
 */
package nl.colorize.multimedialib.renderer.teavm;

import nl.colorize.multimedialib.graphics.ColorRGB;
import nl.colorize.multimedialib.graphics.FontStyle;
import nl.colorize.multimedialib.graphics.Primitive;
import nl.colorize.multimedialib.graphics.Sprite;
import nl.colorize.multimedialib.graphics.Text;
import nl.colorize.multimedialib.graphics.Transform;
import nl.colorize.multimedialib.math.Circle;
import nl.colorize.multimedialib.math.Line;
import nl.colorize.multimedialib.math.Point2D;
import nl.colorize.multimedialib.math.Polygon;
import nl.colorize.multimedialib.math.Rect;
import nl.colorize.multimedialib.renderer.Canvas;
import nl.colorize.multimedialib.renderer.teavm.Browser;
import nl.colorize.multimedialib.renderer.teavm.TeaImage;
import nl.colorize.multimedialib.scene.StageVisitor;
import org.teavm.jso.canvas.CanvasImageSource;
import org.teavm.jso.canvas.CanvasRenderingContext2D;
import org.teavm.jso.dom.html.HTMLCanvasElement;

public class CanvasRenderer
implements StageVisitor {
    private Canvas sceneCanvas;
    private HTMLCanvasElement htmlCanvas;
    private CanvasRenderingContext2D context;

    protected CanvasRenderer(Canvas sceneCanvas) {
        this.sceneCanvas = sceneCanvas;
        this.htmlCanvas = Browser.getCanvas();
        this.context = (CanvasRenderingContext2D)this.htmlCanvas.getContext("2d");
    }

    @Override
    public void drawBackground(ColorRGB color) {
        this.context.clearRect(0.0, 0.0, (double)this.htmlCanvas.getWidth(), (double)this.htmlCanvas.getHeight());
        this.context.setFillStyle(color.toHex());
        this.context.fillRect(0.0, 0.0, (double)this.htmlCanvas.getWidth(), (double)this.htmlCanvas.getHeight());
    }

    @Override
    public void drawSprite(Sprite sprite) {
        TeaImage teaImage = (TeaImage)sprite.getCurrentGraphics();
        Rect region = teaImage.getRegion();
        if (region.getWidth() > 0.0f && region.getHeight() > 0.0f) {
            this.drawImage(teaImage, region, sprite.getPosition(), sprite.getTransform());
        }
    }

    private void drawImage(TeaImage image, Rect region, Point2D position, Transform transform) {
        String mask = transform.getMask() != null ? transform.getMask().toHex() : null;
        CanvasImageSource source = Browser.prepareImage(image.getId(), mask);
        this.context.setGlobalAlpha((double)(transform.getAlpha() / 100.0f));
        this.context.translate((double)this.toScreenX(position), (double)this.toScreenY(position));
        this.context.rotate((double)transform.getRotation() * Math.PI / 180.0);
        this.context.scale((double)(transform.getScaleX() * this.sceneCanvas.getZoomLevel() / 100.0f), (double)(transform.getScaleY() * this.sceneCanvas.getZoomLevel() / 100.0f));
        this.context.drawImage(source, (double)region.getX(), (double)region.getY(), (double)region.getWidth(), (double)region.getHeight(), (double)(-region.getWidth() / 2.0f), (double)(-region.getHeight() / 2.0f), (double)region.getWidth(), (double)region.getHeight());
        this.context.setGlobalAlpha(1.0);
        this.context.setTransform(1.0, 0.0, 0.0, 1.0, 0.0, 0.0);
    }

    @Override
    public void drawLine(Primitive graphic, Line line) {
        this.context.setStrokeStyle(graphic.getColor().toHex());
        this.context.setLineWidth((double)line.getThickness());
        this.context.beginPath();
        this.context.moveTo((double)this.toScreenX(line.getStart()), (double)this.toScreenY(line.getStart()));
        this.context.lineTo((double)this.toScreenX(line.getEnd()), (double)this.toScreenY(line.getEnd()));
        this.context.stroke();
    }

    @Override
    public void drawRect(Primitive graphic, Rect rect) {
        this.context.setGlobalAlpha((double)(graphic.getAlpha() / 100.0f));
        this.context.setFillStyle(graphic.getColor().toHex());
        this.context.fillRect((double)this.toScreenX(rect.getX()), (double)this.toScreenY(rect.getY()), (double)(rect.getWidth() * this.sceneCanvas.getZoomLevel()), (double)(rect.getHeight() * this.sceneCanvas.getZoomLevel()));
        this.context.setGlobalAlpha(1.0);
    }

    @Override
    public void drawCircle(Primitive graphic, Circle circle) {
        this.context.setGlobalAlpha((double)(graphic.getAlpha() / 100.0f));
        this.context.setFillStyle(graphic.getColor().toHex());
        this.context.beginPath();
        this.context.arc((double)this.toScreenX(circle.getCenterX()), (double)this.toScreenY(circle.getCenterY()), (double)(circle.getRadius() * this.sceneCanvas.getZoomLevel()), 0.0, Math.PI * 2);
        this.context.fill();
        this.context.setGlobalAlpha(1.0);
    }

    @Override
    public void drawPolygon(Primitive graphic, Polygon polygon) {
        this.context.setGlobalAlpha((double)(graphic.getAlpha() / 100.0f));
        this.context.setFillStyle(graphic.getColor().toHex());
        this.context.beginPath();
        this.context.moveTo((double)this.toScreenX(polygon.getPointX(0)), (double)this.toScreenY(polygon.getPointY(0)));
        for (int i = 1; i < polygon.getNumPoints(); ++i) {
            this.context.lineTo((double)this.toScreenX(polygon.getPointX(i)), (double)this.toScreenY(polygon.getPointY(i)));
        }
        this.context.fill();
        this.context.setGlobalAlpha(1.0);
    }

    @Override
    public void drawText(Text text) {
        FontStyle style = text.getFont().scale(this.sceneCanvas).getStyle();
        String fontString = (style.bold() ? "bold " : "") + style.size() + "px " + style.family();
        this.context.setGlobalAlpha((double)(text.getAlpha() / 100.0f));
        this.context.setFillStyle(style.color().toHex());
        this.context.setFont(fontString);
        this.context.setTextAlign(text.getAlign().toString().toLowerCase());
        text.forLines((i, line) -> {
            float y = this.toScreenY(text.getPosition().getY() + (float)i.intValue() * text.getLineHeight(this.sceneCanvas));
            this.context.fillText(line, (double)this.toScreenX(text.getPosition()), (double)y);
        });
        this.context.setGlobalAlpha(1.0);
    }

    private float toScreenX(float x) {
        return this.sceneCanvas.toScreenX(x);
    }

    private float toScreenX(Point2D point) {
        return this.sceneCanvas.toScreenX(point.getX());
    }

    private float toScreenY(float y) {
        return this.sceneCanvas.toScreenY(y);
    }

    private float toScreenY(Point2D point) {
        return this.sceneCanvas.toScreenY(point.getY());
    }
}

