/*
 * Decompiled with CFR 0.152.
 */
package nl.colorize.multimedialib.renderer.teavm;

import com.google.common.base.Preconditions;
import java.util.UUID;
import nl.colorize.multimedialib.graphics.ColorRGB;
import nl.colorize.multimedialib.graphics.Image;
import nl.colorize.multimedialib.math.Rect;
import nl.colorize.multimedialib.renderer.FilePointer;
import nl.colorize.multimedialib.renderer.teavm.Browser;

public class TeaImage
implements Image {
    private String id;
    private FilePointer origin;
    private Rect region;
    private int cachedWidth;
    private int cachedHeight;

    protected TeaImage(String id, FilePointer origin, Rect region) {
        Preconditions.checkArgument((region == null || region.getWidth() > 0.0f && region.getHeight() > 0.0f ? 1 : 0) != 0, (Object)("Invalid region for image " + origin + ": " + region));
        this.id = id;
        this.origin = origin;
        this.region = region;
    }

    public String getId() {
        return this.id;
    }

    public FilePointer getOrigin() {
        return this.origin;
    }

    private void cacheImageSize() {
        if (this.region == null || this.region.getWidth() == 0.0f || this.region.getHeight() == 0.0f) {
            this.region = new Rect(0.0f, 0.0f, Browser.getImageWidth(this.id), Browser.getImageHeight(this.id));
        }
        if (this.cachedWidth == 0 || this.cachedHeight == 0) {
            this.cachedWidth = Math.round(this.region.getWidth());
            this.cachedHeight = Math.round(this.region.getHeight());
        }
    }

    @Override
    public Rect getRegion() {
        this.cacheImageSize();
        return this.region;
    }

    @Override
    public int getWidth() {
        this.cacheImageSize();
        return this.cachedWidth;
    }

    @Override
    public int getHeight() {
        this.cacheImageSize();
        return this.cachedHeight;
    }

    @Override
    public TeaImage extractRegion(Rect region) {
        return new TeaImage(this.id, this.origin, region);
    }

    @Override
    public ColorRGB getColor(int x, int y) {
        float[] rgba = Browser.getImageData(this.id, x, y);
        int r = Math.round(rgba[0]);
        int g = Math.round(rgba[1]);
        int b = Math.round(rgba[2]);
        if (r < 0) {
            return null;
        }
        return new ColorRGB(r, g, b);
    }

    @Override
    public int getAlpha(int x, int y) {
        float[] rgba = Browser.getImageData(this.id, x, y);
        return Math.round(rgba[3] / 2.55f);
    }

    @Override
    public Image tint(ColorRGB color) {
        String newId = this.id + "-tinted-" + UUID.randomUUID();
        Browser.tintImage(this.id, newId, color.toHex());
        return new TeaImage(newId, this.origin, this.region);
    }

    public String toString() {
        return this.origin.getPath();
    }
}

