/*
 * Decompiled with CFR 0.152.
 */
package nl.colorize.multimedialib.renderer.teavm;

import com.google.common.base.Splitter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.stream.Collectors;
import nl.colorize.multimedialib.graphics.FontStyle;
import nl.colorize.multimedialib.graphics.Image;
import nl.colorize.multimedialib.graphics.OutlineFont;
import nl.colorize.multimedialib.graphics.PolygonModel;
import nl.colorize.multimedialib.renderer.Audio;
import nl.colorize.multimedialib.renderer.FilePointer;
import nl.colorize.multimedialib.renderer.MediaLoader;
import nl.colorize.multimedialib.renderer.UnsupportedGraphicsModeException;
import nl.colorize.multimedialib.renderer.teavm.Browser;
import nl.colorize.multimedialib.renderer.teavm.TeaAudio;
import nl.colorize.multimedialib.renderer.teavm.TeaFont;
import nl.colorize.multimedialib.renderer.teavm.TeaImage;
import nl.colorize.util.Configuration;
import nl.colorize.util.LoadUtils;
import nl.colorize.util.PlatformFamily;

public class TeaMediaLoader
implements MediaLoader {
    private Map<FilePointer, ProgressTracker> progressTrackers = new LinkedHashMap<FilePointer, ProgressTracker>();
    private List<TeaImage> loadedImages = new ArrayList<TeaImage>();
    private int nextAudioId = 1;
    private int nextFontId = 1;
    private List<FilePointer> manifest = Collections.emptyList();
    private static final FilePointer MANIFEST_FILE = new FilePointer("resource-file-manifest");
    private static final Splitter LINE_SPLITTER = Splitter.on((String)"\n").trimResults().omitEmptyStrings();

    public boolean checkLoadingProgress() {
        LinkedHashMap<FilePointer, ProgressTracker> remaining = new LinkedHashMap<FilePointer, ProgressTracker>();
        for (Map.Entry<FilePointer, ProgressTracker> entry : this.progressTrackers.entrySet()) {
            if (entry.getValue().isLoadingComplete()) continue;
            remaining.put(entry.getKey(), entry.getValue());
        }
        this.progressTrackers = remaining;
        return remaining.isEmpty();
    }

    @Override
    public Image loadImage(FilePointer file) {
        String id = String.valueOf(this.loadedImages.size() + 1);
        Browser.loadImage(id, "resources/" + this.normalizeFilePath(file, false));
        TeaImage imagePointer = new TeaImage(id, file, null);
        this.loadedImages.add(imagePointer);
        this.progressTrackers.put(file, () -> Browser.getImageHeight(id) > 0.0f);
        return imagePointer;
    }

    @Override
    public Audio loadAudio(FilePointer file) {
        String id = String.valueOf(this.nextAudioId);
        Browser.loadAudio(id, "resources/" + this.normalizeFilePath(file, false));
        ++this.nextAudioId;
        return new TeaAudio(id);
    }

    @Override
    public OutlineFont loadFont(FilePointer file, FontStyle style) {
        String id = String.valueOf(this.nextFontId);
        Browser.loadFont(id, "resources/" + this.normalizeFilePath(file, false), style.family());
        ++this.nextFontId;
        return new TeaFont(id, style);
    }

    @Override
    public PolygonModel loadModel(FilePointer file) {
        throw new UnsupportedGraphicsModeException();
    }

    @Override
    public String loadText(FilePointer file) {
        return Browser.loadTextResourceFile(this.normalizeFilePath(file, true));
    }

    @Override
    public boolean containsResourceFile(FilePointer file) {
        String fileEntry = file.getPath();
        if (fileEntry.indexOf(47) != -1) {
            fileEntry = fileEntry.substring(fileEntry.lastIndexOf(47) + 1);
        }
        for (FilePointer entry : this.loadResourceFileManifest()) {
            if (!entry.getPath().equals(fileEntry)) continue;
            return true;
        }
        return false;
    }

    private List<FilePointer> loadResourceFileManifest() {
        if (!this.manifest.isEmpty()) {
            return this.manifest;
        }
        this.manifest = LINE_SPLITTER.splitToList((CharSequence)this.loadText(MANIFEST_FILE)).stream().map(path -> new FilePointer((String)path)).collect(Collectors.toList());
        return this.manifest;
    }

    protected String normalizeFilePath(FilePointer file, boolean replaceDot) {
        String normalized = file.getPath();
        if (normalized.indexOf(47) != -1) {
            normalized = normalized.substring(normalized.lastIndexOf(47) + 1);
        }
        if (replaceDot) {
            normalized = normalized.replace(".", "_");
        }
        return normalized;
    }

    @Override
    public Configuration loadApplicationData(String appName, String fileName) {
        String value = Browser.getLocalStorage(appName + "." + fileName);
        if (value == null || value.isEmpty()) {
            return Configuration.fromProperties();
        }
        Properties properties = LoadUtils.loadProperties((String)value);
        return Configuration.fromProperties((Properties)properties);
    }

    @Override
    public void saveApplicationData(Configuration data, String appName, String fileName) {
        Browser.setLocalStorage(appName + "." + fileName, data.serialize());
    }

    @Override
    public PlatformFamily getPlatformFamily() {
        String userAgent = Browser.getUserAgent().toLowerCase();
        if (userAgent.contains("iphone") || userAgent.contains("ipad")) {
            return PlatformFamily.IOS;
        }
        if (userAgent.contains("android")) {
            return PlatformFamily.ANDROID;
        }
        if (userAgent.contains("mac")) {
            return PlatformFamily.MAC;
        }
        return PlatformFamily.WINDOWS;
    }

    @FunctionalInterface
    private static interface ProgressTracker {
        public boolean isLoadingComplete();
    }
}

