/*
 * Decompiled with CFR 0.152.
 */
package nl.colorize.multimedialib.renderer.teavm;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.logging.Logger;
import nl.colorize.multimedialib.renderer.NetworkAccess;
import nl.colorize.multimedialib.renderer.NetworkConnection;
import nl.colorize.util.Callback;
import nl.colorize.util.LogHelper;
import nl.colorize.util.Tuple;
import nl.colorize.util.http.Headers;
import nl.colorize.util.http.PostData;
import org.teavm.jso.ajax.XMLHttpRequest;
import org.teavm.jso.websocket.WebSocket;

public class TeaNetworkAccess
implements NetworkAccess {
    private static final Logger LOGGER = LogHelper.getLogger(TeaNetworkAccess.class);

    @Override
    public void get(String url, Headers headers, Callback<String> callback) {
        XMLHttpRequest request = XMLHttpRequest.create();
        request.setOnReadyStateChange(() -> this.handleResponse(request, callback));
        request.open("GET", url, true);
        this.addRequestHeaders(request, headers);
        request.send();
    }

    @Override
    public void post(String url, Headers headers, PostData data, Callback<String> callback) {
        XMLHttpRequest request = XMLHttpRequest.create();
        request.setOnReadyStateChange(() -> this.handleResponse(request, callback));
        request.open("POST", url, true);
        this.addRequestHeaders(request, headers);
        request.send(data.encode(StandardCharsets.UTF_8));
    }

    private void addRequestHeaders(XMLHttpRequest request, Headers headers) {
        request.setRequestHeader("X-Requested-With", "MultimediaLib");
        for (Tuple header : headers.getEntries()) {
            request.setRequestHeader((String)header.getKey(), (String)header.getValue());
        }
    }

    private void handleResponse(XMLHttpRequest request, Callback<String> callback) {
        if (request.getReadyState() == 4) {
            if (request.getStatus() >= 200 && request.getStatus() <= 204) {
                String response = request.getResponseText();
                callback.onResponse((Object)response);
            } else {
                callback.onError((Throwable)new IOException("AJAX request failed: " + request.getStatusText()));
            }
        }
    }

    @Override
    public NetworkConnection connectWebSocket(String uri) {
        WebSocket webSocket = WebSocket.create((String)uri);
        NetworkConnection connection = new NetworkConnection(message -> webSocket.send(message));
        webSocket.onOpen(message -> {
            connection.receiveID(uri);
            connection.connect();
        });
        webSocket.onMessage(message -> connection.queueReceivedMessage(message.getDataAsString()));
        webSocket.onError(event -> LOGGER.warning("Web socket error"));
        return connection;
    }

    @Override
    public NetworkConnection connectWebRTC(String id) {
        throw new UnsupportedOperationException();
    }
}

