/*
 * Decompiled with CFR 0.152.
 */
package nl.colorize.multimedialib.renderer.teavm;

import java.util.logging.Level;
import java.util.logging.Logger;
import nl.colorize.multimedialib.renderer.Canvas;
import nl.colorize.multimedialib.renderer.DisplayMode;
import nl.colorize.multimedialib.renderer.Renderer;
import nl.colorize.multimedialib.renderer.teavm.Browser;
import nl.colorize.multimedialib.renderer.teavm.CanvasRenderer;
import nl.colorize.multimedialib.renderer.teavm.TeaInputDevice;
import nl.colorize.multimedialib.renderer.teavm.TeaMediaLoader;
import nl.colorize.multimedialib.renderer.teavm.TeaNetworkAccess;
import nl.colorize.multimedialib.renderer.teavm.WebGraphics;
import nl.colorize.multimedialib.renderer.teavm.pixi.PixiRenderer;
import nl.colorize.multimedialib.renderer.teavm.three.ThreeRenderer;
import nl.colorize.multimedialib.scene.ErrorHandler;
import nl.colorize.multimedialib.scene.Scene;
import nl.colorize.multimedialib.scene.SceneContext;
import nl.colorize.multimedialib.scene.StageObserver;
import nl.colorize.multimedialib.scene.StageVisitor;
import nl.colorize.util.LogHelper;
import org.teavm.jso.browser.AnimationFrameCallback;
import org.teavm.jso.browser.Window;

public class TeaRenderer
implements Renderer {
    private WebGraphics graphicsMode;
    private Canvas canvas;
    private TeaInputDevice inputDevice;
    private TeaMediaLoader mediaLoader;
    private SceneContext context;
    private StageVisitor stageVisitor;
    private ErrorHandler errorHandler;
    private int framerate;
    private float frameTime;
    private double lastFrameTimestamp;
    private static final Logger LOGGER = LogHelper.getLogger(TeaRenderer.class);

    public TeaRenderer(DisplayMode displayMode, WebGraphics graphicsMode) {
        this.graphicsMode = graphicsMode;
        this.canvas = displayMode.canvas();
        this.mediaLoader = new TeaMediaLoader();
        this.inputDevice = new TeaInputDevice(this.canvas, this.mediaLoader.getPlatformFamily());
        TeaNetworkAccess network = new TeaNetworkAccess();
        this.context = new SceneContext(displayMode, this.inputDevice, this.mediaLoader, network);
        this.errorHandler = ErrorHandler.DEFAULT;
        this.framerate = displayMode.framerate();
        this.frameTime = 1.0f / (float)this.framerate;
        this.lastFrameTimestamp = 0.0;
    }

    @Override
    public void start(Scene initialScene, ErrorHandler errorHandler) {
        LOGGER.info("Using graphics mode " + this.graphicsMode);
        switch (this.graphicsMode) {
            default: {
                throw new IncompatibleClassChangeError();
            }
            case CANVAS: {
                StageVisitor stageVisitor = new CanvasRenderer(this.canvas);
                break;
            }
            case PIXI: {
                StageVisitor stageVisitor = new PixiRenderer(this.canvas);
                break;
            }
            case THREE: {
                StageVisitor stageVisitor = this.stageVisitor = new ThreeRenderer(this.canvas);
            }
        }
        if (this.stageVisitor instanceof StageObserver) {
            this.context.getStage().addObserver((StageObserver)((Object)this.stageVisitor));
        }
        if (this.stageVisitor instanceof PixiRenderer) {
            this.inputDevice.setPixelRatio(1.0f);
        }
        this.errorHandler = errorHandler;
        this.context.changeScene(initialScene);
        AnimationFrameCallback callback = this::onAnimationFrame;
        Window.requestAnimationFrame((AnimationFrameCallback)callback);
    }

    private void onAnimationFrame(double timestamp) {
        try {
            int canvasWidth = Math.round(Browser.getCanvasWidth());
            int canvasHeight = Math.round(Browser.getCanvasHeight());
            float deltaTime = (float)(timestamp - this.lastFrameTimestamp) / 1000.0f;
            if (this.updateCanvas(canvasWidth, canvasHeight) && (this.framerate >= 60 || deltaTime >= this.frameTime)) {
                this.context.getFrameStats().markFrameStart();
                this.inputDevice.update(this.frameTime);
                this.context.update(this.frameTime);
                this.context.getFrameStats().markFrameUpdate();
                this.context.getStage().visit(this.stageVisitor);
                this.context.getFrameStats().markFrameRender();
                this.lastFrameTimestamp = timestamp;
            }
            AnimationFrameCallback callback = this::onAnimationFrame;
            Window.requestAnimationFrame((AnimationFrameCallback)callback);
        }
        catch (Exception e) {
            LOGGER.log(Level.SEVERE, "Error during animation loop", e);
            this.errorHandler.onError(this.context, e);
        }
    }

    private boolean updateCanvas(int width, int height) {
        if (width > 0 && height > 0) {
            this.canvas.resizeScreen(width, height);
            return this.mediaLoader.checkLoadingProgress();
        }
        return false;
    }

    @Override
    public String takeScreenshot() {
        return Browser.takeScreenshot();
    }

    @Override
    public DisplayMode getDisplayMode() {
        return new DisplayMode(this.canvas, this.framerate);
    }
}

