/*
 * Decompiled with CFR 0.152.
 */
package nl.colorize.multimedialib.renderer.teavm.pixi;

import java.util.HashMap;
import java.util.Map;
import nl.colorize.multimedialib.graphics.ColorRGB;
import nl.colorize.multimedialib.graphics.FontStyle;
import nl.colorize.multimedialib.graphics.Graphic2D;
import nl.colorize.multimedialib.graphics.Primitive;
import nl.colorize.multimedialib.graphics.Sprite;
import nl.colorize.multimedialib.graphics.Text;
import nl.colorize.multimedialib.graphics.Transform;
import nl.colorize.multimedialib.math.Circle;
import nl.colorize.multimedialib.math.Line;
import nl.colorize.multimedialib.math.Point2D;
import nl.colorize.multimedialib.math.Polygon;
import nl.colorize.multimedialib.math.Rect;
import nl.colorize.multimedialib.renderer.Canvas;
import nl.colorize.multimedialib.renderer.teavm.Browser;
import nl.colorize.multimedialib.renderer.teavm.TeaImage;
import nl.colorize.multimedialib.renderer.teavm.pixi.PixiDisplayObject;
import nl.colorize.multimedialib.renderer.teavm.pixi.PixiInterface;
import nl.colorize.multimedialib.renderer.teavm.pixi.PixiTexture;
import nl.colorize.multimedialib.scene.Layer;
import nl.colorize.multimedialib.scene.Stage;
import nl.colorize.multimedialib.scene.StageObserver;
import nl.colorize.multimedialib.scene.StageVisitor;

public class PixiRenderer
implements StageVisitor,
StageObserver {
    private Canvas canvas;
    private PixiInterface pixi;
    private Map<Graphic2D, PixiDisplayObject> displayObjects;
    private Graphic2D currentGraphic;
    private PixiDisplayObject currentDisplayObject;
    private int zIndex;

    public PixiRenderer(Canvas canvas) {
        this.canvas = canvas;
        this.displayObjects = new HashMap<Graphic2D, PixiDisplayObject>();
        this.pixi = Browser.initPixiInterface();
    }

    @Override
    public void preVisitStage(Stage stage) {
        this.currentGraphic = null;
        this.zIndex = 1;
    }

    @Override
    public void preVisitGraphic(Graphic2D graphic, boolean visible) {
        this.currentGraphic = graphic;
        this.currentDisplayObject = this.displayObjects.get(this.currentGraphic);
        this.currentDisplayObject.setVisible(visible);
    }

    @Override
    public void drawBackground(ColorRGB color) {
        this.pixi.changeBackgroundColor(color.getRGB());
    }

    @Override
    public void drawSprite(Sprite sprite) {
        Transform transform = sprite.getTransform();
        this.currentDisplayObject.setX(this.toScreenX(sprite.getPosition()));
        this.currentDisplayObject.setY(this.toScreenY(sprite.getPosition()));
        this.currentDisplayObject.setAlpha(transform.getAlpha() / 100.0f);
        this.currentDisplayObject.setAngle(transform.getRotation());
        this.currentDisplayObject.getScale().setX(transform.getScaleX() / 100.0f);
        this.currentDisplayObject.getScale().setY(transform.getScaleY() / 100.0f);
        TeaImage image = this.getImage(sprite);
        PixiTexture texture = this.currentDisplayObject.getTexture();
        texture.getFrame().setX(image.getRegion().getX());
        texture.getFrame().setY(image.getRegion().getY());
        texture.getFrame().setWidth(image.getRegion().getWidth());
        texture.getFrame().setHeight(image.getRegion().getHeight());
        texture.updateUvs();
        this.updateTint(sprite.getTransform().getMask());
    }

    private void updateTint(ColorRGB tintColor) {
        if (!this.currentDisplayObject.isTintEnabled() && tintColor != null) {
            this.pixi.applyTint(this.currentDisplayObject, tintColor.getRGB());
        } else if (this.currentDisplayObject.isTintEnabled() && tintColor == null) {
            this.pixi.clearTint(this.currentDisplayObject);
        }
    }

    @Override
    public void drawLine(Primitive graphic, Line line) {
        this.currentDisplayObject.clear();
        this.currentDisplayObject.lineStyle(line.getThickness(), graphic.getColor().getRGB());
        this.currentDisplayObject.moveTo(this.toScreenX(line.getStart()), this.toScreenY(line.getStart()));
        this.currentDisplayObject.lineTo(this.toScreenX(line.getEnd()), this.toScreenY(line.getEnd()));
        this.currentDisplayObject.setAlpha(graphic.getAlpha() / 100.0f);
    }

    @Override
    public void drawRect(Primitive graphic, Rect rect) {
        this.currentDisplayObject.clear();
        this.currentDisplayObject.beginFill(graphic.getColor().getRGB(), 1.0f);
        this.currentDisplayObject.drawRect(this.toScreenX(rect.getX()), this.toScreenY(rect.getY()), rect.getWidth() * this.canvas.getZoomLevel(), rect.getHeight() * this.canvas.getZoomLevel());
        this.currentDisplayObject.endFill();
        this.currentDisplayObject.setAlpha(graphic.getAlpha() / 100.0f);
    }

    @Override
    public void drawCircle(Primitive graphic, Circle circle) {
        this.currentDisplayObject.clear();
        this.currentDisplayObject.beginFill(graphic.getColor().getRGB(), 1.0f);
        this.currentDisplayObject.drawCircle(this.toScreenX(circle.getCenterX()), this.toScreenY(circle.getCenterY()), circle.getRadius() * this.canvas.getZoomLevel());
        this.currentDisplayObject.endFill();
        this.currentDisplayObject.setAlpha(graphic.getAlpha() / 100.0f);
    }

    @Override
    public void drawPolygon(Primitive graphic, Polygon polygon) {
        float[] points = new float[polygon.getNumPoints() * 2];
        for (int i = 0; i < polygon.getNumPoints(); ++i) {
            points[i * 2] = this.toScreenX(polygon.getPointX(i));
            points[i * 2 + 1] = this.toScreenY(polygon.getPointY(i));
        }
        this.currentDisplayObject.clear();
        this.currentDisplayObject.beginFill(graphic.getColor().getRGB(), 1.0f);
        this.currentDisplayObject.drawPolygon(points);
        this.currentDisplayObject.endFill();
        this.currentDisplayObject.setAlpha(graphic.getAlpha() / 100.0f);
    }

    @Override
    public void drawText(Text text) {
        this.currentDisplayObject.setText(text.getText());
        this.currentDisplayObject.setX(this.toScreenX(text.getPosition()));
        this.currentDisplayObject.setY(this.toScreenY(text.getPosition()));
        this.currentDisplayObject.setAlpha(text.getAlpha() / 100.0f);
    }

    private float toScreenX(float x) {
        return this.canvas.toScreenX(x);
    }

    private float toScreenX(Point2D point) {
        return this.canvas.toScreenX(point.getX());
    }

    private float toScreenY(float y) {
        return this.canvas.toScreenY(y);
    }

    private float toScreenY(Point2D point) {
        return this.canvas.toScreenY(point.getY());
    }

    @Override
    public void onGraphicAdded(Layer layer, Graphic2D graphic) {
        if (!this.pixi.hasLayer(layer.getName())) {
            this.pixi.createLayer(layer.getName());
        }
        ++this.zIndex;
        PixiDisplayObject displayObject = this.createDisplayObject(layer, graphic);
        displayObject.setZIndex(this.zIndex);
        this.displayObjects.put(graphic, displayObject);
    }

    private PixiDisplayObject createDisplayObject(Layer layer, Graphic2D graphic) {
        if (graphic instanceof Sprite) {
            TeaImage image = this.getImage((Sprite)graphic);
            Rect region = image.getRegion();
            return this.pixi.createSprite(layer.getName(), image.getId(), region.getX(), region.getY(), region.getWidth(), region.getHeight());
        }
        if (graphic instanceof Primitive) {
            return this.pixi.createGraphics(layer.getName());
        }
        if (graphic instanceof Text) {
            Text text = (Text)graphic;
            FontStyle style = text.getFont().scale(this.canvas).getStyle();
            return this.pixi.createText(layer.getName(), style.family(), style.size(), style.bold(), text.getAlign().toString(), text.getLineHeight(this.canvas), style.color().getRGB());
        }
        throw new IllegalArgumentException("Unknown graphics type: " + graphic);
    }

    private TeaImage getImage(Sprite sprite) {
        return (TeaImage)sprite.getCurrentGraphics();
    }

    @Override
    public void onGraphicRemoved(Layer layer, Graphic2D graphic) {
        PixiDisplayObject displayObject = this.displayObjects.get(graphic);
        if (displayObject != null) {
            this.pixi.removeDisplayObject(layer.getName(), displayObject);
        }
    }

    @Override
    public void onStageCleared() {
        this.pixi.clearStage();
    }
}

