/*
 * Decompiled with CFR 0.152.
 */
package nl.colorize.multimedialib.scene;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.stream.Collectors;
import nl.colorize.multimedialib.scene.Component;
import nl.colorize.multimedialib.scene.Updatable;

public class Actor
implements Updatable {
    private UUID id;
    private Map<Class<? extends Component>, Component> components;

    public Actor(UUID id, List<Component> components) {
        this.id = id;
        this.components = ImmutableMap.copyOf(components.stream().collect(Collectors.toMap(c -> c.getClass(), c -> c)));
    }

    public Actor(UUID id, Component ... components) {
        this(id, (List<Component>)ImmutableList.copyOf((Object[])components));
    }

    public Actor(List<Component> components) {
        this(UUID.randomUUID(), components);
    }

    public Actor(Component ... components) {
        this((List<Component>)ImmutableList.copyOf((Object[])components));
    }

    public UUID getId() {
        return this.id;
    }

    public boolean hasComponent(Class<? extends Component> componentClass) {
        return this.components.containsKey(componentClass);
    }

    public <T extends Component> T getComponent(Class<T> componentClass) {
        Component component = this.components.get(componentClass);
        Preconditions.checkState((component != null ? 1 : 0) != 0, (Object)("Entity does not have component " + componentClass));
        return (T)component;
    }

    public Iterable<Component> getComponents() {
        return this.components.values();
    }

    @Override
    public void update(float deltaTime) {
        for (Component component : this.components.values()) {
            component.update(deltaTime);
        }
    }
}

