/*
 * Decompiled with CFR 0.152.
 */
package nl.colorize.multimedialib.scene;

import java.util.ArrayList;
import java.util.function.Consumer;
import nl.colorize.multimedialib.scene.SceneContext;
import nl.colorize.multimedialib.scene.Timer;
import nl.colorize.multimedialib.scene.Updatable;
import nl.colorize.util.animation.Timeline;

@FunctionalInterface
public interface ActorSystem {
    default public void init(SceneContext context) {
    }

    public void update(SceneContext var1, float var2);

    default public boolean isCompleted() {
        return false;
    }

    public static ActorSystem wrap(Updatable delegate) {
        return (context, deltaTime) -> delegate.update(deltaTime);
    }

    public static ActorSystem timed(float duration, final Runnable action) {
        final Timer timer = new Timer(duration);
        return new ActorSystem(){

            @Override
            public void update(SceneContext context, float deltaTime) {
                timer.update(deltaTime);
                action.run();
            }

            @Override
            public boolean isCompleted() {
                return timer.isCompleted();
            }
        };
    }

    public static ActorSystem delay(float duration, final Runnable action) {
        final Timer timer = new Timer(duration);
        return new ActorSystem(){

            @Override
            public void update(SceneContext context, float deltaTime) {
                timer.update(deltaTime);
                if (timer.isCompleted()) {
                    action.run();
                }
            }

            @Override
            public boolean isCompleted() {
                return timer.isCompleted();
            }
        };
    }

    public static ActorSystem fromTimeline(final Timeline timeline, final Consumer<Float> action) {
        return new ActorSystem(){

            @Override
            public void update(SceneContext context, float deltaTime) {
                timeline.movePlayhead(deltaTime);
                action.accept(Float.valueOf(timeline.getValue()));
            }

            @Override
            public boolean isCompleted() {
                return timeline.isCompleted() && !timeline.isLoop();
            }
        };
    }

    public static ActorSystem sequence(ActorSystem a, ActorSystem b) {
        final ArrayList<ActorSystem> remaining = new ArrayList<ActorSystem>();
        remaining.add(a);
        remaining.add(b);
        return new ActorSystem(){

            @Override
            public void update(SceneContext context, float deltaTime) {
                ActorSystem current = (ActorSystem)remaining.get(0);
                current.update(context, deltaTime);
                if (current.isCompleted()) {
                    remaining.remove(0);
                }
            }

            @Override
            public boolean isCompleted() {
                return remaining.isEmpty();
            }
        };
    }
}

