/*
 * Decompiled with CFR 0.152.
 */
package nl.colorize.multimedialib.scene;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Supplier;
import nl.colorize.multimedialib.graphics.Graphic2D;
import nl.colorize.multimedialib.math.Point2D;
import nl.colorize.multimedialib.renderer.InputDevice;
import nl.colorize.multimedialib.scene.ActorSystem;
import nl.colorize.multimedialib.scene.Layer;
import nl.colorize.multimedialib.scene.SceneContext;
import nl.colorize.multimedialib.scene.Stage;
import nl.colorize.multimedialib.scene.Timer;
import nl.colorize.multimedialib.scene.Updatable;
import nl.colorize.util.animation.Timeline;

public final class DisplayObject
implements ActorSystem {
    private List<Graphic2D> graphics = new ArrayList<Graphic2D>();
    private String layer = Layer.DEFAULT.getName();
    private List<Updatable> frameHandlers = new ArrayList<Updatable>();
    private List<Runnable> clickHandlers = new ArrayList<Runnable>();
    private List<Runnable> terminationHandlers = new ArrayList<Runnable>();
    private Stage stage = null;
    private boolean terminated = false;

    public DisplayObject withGraphics(Graphic2D ... graphics) {
        return this.withGraphics((List<Graphic2D>)ImmutableList.copyOf((Object[])graphics));
    }

    public DisplayObject withGraphics(List<Graphic2D> graphics) {
        Preconditions.checkState((!this.isInitialized() ? 1 : 0) != 0, (Object)"DisplayObject already initialized");
        Preconditions.checkState((!this.terminated ? 1 : 0) != 0, (Object)"DisplayObject already terminated");
        this.graphics.addAll(graphics);
        return this;
    }

    public DisplayObject withLayer(Layer layer) {
        return this.withLayer(layer.getName());
    }

    public DisplayObject withLayer(String layerName) {
        Preconditions.checkState((!this.isInitialized() ? 1 : 0) != 0, (Object)"DisplayObject already initialized");
        Preconditions.checkState((!this.terminated ? 1 : 0) != 0, (Object)"DisplayObject already terminated");
        this.layer = layerName;
        return this;
    }

    public DisplayObject withFrameHandler(Updatable handler) {
        Preconditions.checkState((!this.terminated ? 1 : 0) != 0, (Object)"DisplayObject already terminated");
        this.frameHandlers.add(handler);
        return this;
    }

    public DisplayObject withClickHandler(Runnable handler) {
        Preconditions.checkState((!this.terminated ? 1 : 0) != 0, (Object)"DisplayObject already terminated");
        this.clickHandlers.add(handler);
        return this;
    }

    public DisplayObject withTerminationHandler(Runnable handler) {
        Preconditions.checkState((!this.terminated ? 1 : 0) != 0, (Object)"DisplayObject already terminated");
        this.terminationHandlers.add(handler);
        return this;
    }

    public DisplayObject withTimelineHandler(Timeline timeline, Consumer<Float> callback) {
        return this.withFrameHandler(deltaTime -> {
            timeline.movePlayhead(deltaTime);
            callback.accept(Float.valueOf(timeline.getValue()));
            if (timeline.isCompleted() && !timeline.isLoop()) {
                this.terminate();
            }
        });
    }

    public DisplayObject stopAfter(float duration) {
        Timer timer = new Timer(duration);
        return this.withFrameHandler(deltaTime -> {
            timer.update(deltaTime);
            if (timer.isCompleted()) {
                this.terminate();
            }
        });
    }

    public DisplayObject stopIf(Supplier<Boolean> condition) {
        return this.withFrameHandler(deltaTime -> {
            if (((Boolean)condition.get()).booleanValue()) {
                this.terminate();
            }
        });
    }

    @Override
    public void init(SceneContext context) {
        Preconditions.checkState((!this.isInitialized() ? 1 : 0) != 0, (Object)"DisplayObject already initialized");
        Preconditions.checkState((!this.terminated ? 1 : 0) != 0, (Object)"DisplayObject already terminated");
        this.stage = context.getStage();
        for (Graphic2D graphic : this.graphics) {
            Preconditions.checkState((!this.stage.contains(graphic) ? 1 : 0) != 0, (Object)("Graphic has already been added to stage: " + this.stage));
            this.stage.add(this.layer, graphic);
        }
    }

    private boolean isInitialized() {
        return this.stage != null;
    }

    @Override
    public void update(SceneContext context, float deltaTime) {
        if (!this.terminated) {
            for (Updatable frameHandler : this.frameHandlers) {
                frameHandler.update(deltaTime);
            }
            if (!this.clickHandlers.isEmpty()) {
                this.updateInput(context.getInputDevice());
            }
        }
    }

    private void updateInput(InputDevice inputDevice) {
        if (inputDevice.isPointerReleased() && this.hitTest(inputDevice.getPointers())) {
            for (Runnable clickHandler : this.clickHandlers) {
                clickHandler.run();
            }
        }
    }

    private boolean hitTest(List<Point2D> points) {
        return points.stream().anyMatch(this::hitTest);
    }

    public boolean hitTest(Point2D point) {
        return this.graphics.stream().anyMatch(graphic -> graphic.hitTest(point));
    }

    public void extendGraphics(Graphic2D graphic) {
        if (!this.terminated) {
            if (this.isInitialized()) {
                this.graphics.add(graphic);
                this.stage.add(this.layer, graphic);
            } else {
                this.withGraphics(graphic);
            }
        }
    }

    public void terminate() {
        if (this.terminated) {
            return;
        }
        this.terminated = true;
        this.terminationHandlers.forEach(Runnable::run);
        if (this.stage != null) {
            this.graphics.forEach(graphic -> this.stage.remove(this.layer, (Graphic2D)graphic));
            this.stage = null;
        }
    }

    @Override
    public boolean isCompleted() {
        return this.terminated;
    }

    public void attachTo(SceneContext context) {
        Preconditions.checkState((!this.isInitialized() ? 1 : 0) != 0, (Object)"DisplayObject already initialized");
        context.attach(this);
    }
}

