/*
 * Decompiled with CFR 0.152.
 */
package nl.colorize.multimedialib.scene;

import com.google.common.annotations.VisibleForTesting;
import nl.colorize.multimedialib.renderer.DisplayMode;
import nl.colorize.multimedialib.renderer.Renderer;
import nl.colorize.multimedialib.renderer.WindowOptions;
import nl.colorize.multimedialib.renderer.headless.HeadlessRenderer;
import nl.colorize.multimedialib.renderer.java2d.Java2DRenderer;
import nl.colorize.multimedialib.renderer.libgdx.GDXRenderer;
import nl.colorize.multimedialib.renderer.teavm.TeaRenderer;
import nl.colorize.multimedialib.renderer.teavm.WebGraphics;
import nl.colorize.util.Platform;

public final class MultimediaAppLauncher {
    private MultimediaAppLauncher() {
    }

    public static Renderer launchJava2D(DisplayMode displayMode, WindowOptions window) {
        return new Java2DRenderer(displayMode, window);
    }

    public static Renderer launchGDX(DisplayMode displayMode, WindowOptions window) {
        return new GDXRenderer(displayMode, window);
    }

    public static Renderer launchTea(DisplayMode displayMode, WebGraphics graphicsMode) {
        Platform.enableTeaVM();
        return new TeaRenderer(displayMode, graphicsMode);
    }

    @VisibleForTesting
    public static Renderer headless() {
        return new HeadlessRenderer();
    }
}

